@echo off
rem   BATCH file to RUN vmixing

SETLOCAL ENABLEDELAYEDEXPANSION

rem   parameters for vmixing_run_001 and vmixing_set_001:

rem   parameter #1: latitude
rem   parameter #2: longitude
rem   parameter #3: start height
rem   parameter #4: directory for met file
rem   parameter #5: name of met file
rem   parameter #6: run name
rem   parameter #7: stability method (KBLS)
rem   parameter #8: PBL mixing scheme (KBLT)
rem   parameter #9: Optional ouptut variables
rem   parameter #10: start yr
rem   parameter #11: start mo
rem   parameter #12: start da
rem   parameter #13: start hr
rem   parameter #14: number of hours to run
rem   parameter #15: KMIXD
rem   parameter #16: KMIX0

rem   the user will need to specify what directory the specified met data files are in
rem   this is the directory that was used during the testing of this script

SET METDATA_DIRECTORY=D:\METDATA\global_reanalysis\

rem   here is the first run, for the Jan 2012 global reanalysis met data file

CALL vmixing_set_001 39.028 -76.817 0.0 %METDATA_DIRECTORY% RP201206.gbl gbl2p5_06_2012_base 2 2 2 00 00 00 00 9999 0 50

rem   a "pause" command is inserted here so that the user can stop the script (with a CNTL-C) 
rem   if there are abvious errors in carrying out the first run
rem   otherwise, any key can be pressed and the script will continue

rem   this is particularly important if you are doing a lot of different runs in a
rem   script and want to make sure it is working before it tries the subsequent runs.

pause

rem   the following call to vmixing_set_001, to run the next month, is commented out, 
rem   but is shown as an example of how different simulations can be strung together in a script.
rem   if this line is enabled (i.e., if the "rem" is removed), then the met file 
rem   RP201207.gbl would have to downloaded first before the run could be carried out.

rem   CALL vmixing_set_001 39.028 -76.817 0.0 %METDATA_DIRECTORY% RP201207.gbl gbl2p5_07_2012_base 2 2 2 00 00 00 00 9999 0 50






