#!/bin/sh

#-------------------------------------------------------------

  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0  
        
  run=68
  ztop=10000.0

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL1
  echo "1                      ">>CONTROL1
  echo "$olat $olon $lvl1      ">>CONTROL1
  echo "$run                   ">>CONTROL1
  echo "0                      ">>CONTROL1
  echo "$ztop                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "$MET/                  ">>CONTROL1

  echo "1                      " >CONTROL2
  echo "PMCH                   ">>CONTROL2
  echo "67000.0                ">>CONTROL2
  echo "3.0                    ">>CONTROL2
  echo "00 00 00 00 00         ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "42.0 -78.0             ">>CONTROL2
  echo "0.125 0.125            ">>CONTROL2
  echo "15.0 25.0              ">>CONTROL2
  echo "$OUT/                  ">>CONTROL2
  echo "hysplitX               ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "100                    ">>CONTROL2
  echo "83 09 25 18 00         ">>CONTROL2
  echo "83 09 28 15 00         ">>CONTROL2
  echo "00 03 00               ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  echo "0.0                    ">>CONTROL2

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=20000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplitX.??? statA_*.txt
  rm -f sumstat.txt

  let num=1

  for met in wrf27uw era40 narr wrf27 wrf09; do
      cat CONTROL1  >CONTROL
      echo captex2_${met}.bin  >>CONTROL
      cat CONTROL2 >>CONTROL

      ${MDL}/exec/hycs_std
      NUM=`printf %3.3d $num`

      ${MDL}/exec/c2datem -xi -s -ihysplitX -ohysplit.txt -c1.0E+12 -m${MET}/captex2_meas.txt
      ${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/captex2_meas.txt -l10.0 -o1 -ssumstat.txt

      mv statA.txt statA_${met}.txt
      mv hysplitX hysplitX.$NUM

      let num=$num+1
  done

#----------------------------------------------------------

${MDL}/exec/conprob -bhysplitX -t1 -p1 -z1

echo "'TITLE&','Example 12.1&'"  >LABELS.CFG
${MDL}/exec/boxplots -x-78.80 -y42.25
${MDL}/exec/ensplots -bhysplitX -x-78.80 -y42.25

#--------------------------------------------------------------

${MDL}/exec/c2datem -s -xi -icmean -ohysplit.txt -c1.0E+12 -m${MET}/captex2_meas.txt
${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/captex2_meas.txt -l10.0 -o1 -ssumstat.txt
${MDL}/exec/scatter -idataA.txt -p10.0
mv statA.txt statA_cmean.txt
