@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
     
SET LAT1=38.0
SET LAT2=44.0
SET LAT3=39.0

SET LON1=-84.0
SET LON2=-74.0
SET LON3=-83.0

SET LVL=600.0
        
SET RUN=6
SET TOP=10000.0
SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL
echo 3                       >>CONTROL
echo %LAT1% %LON1% %LVL%     >>CONTROL
echo %LAT2% %LON2% %LVL%     >>CONTROL
echo %LAT3% %LON3% %LVL%     >>CONTROL
echo %RUN%                   >>CONTROL
echo 0                       >>CONTROL
echo %TOP%                   >>CONTROL
echo 1                       >>CONTROL
echo %MET%\                  >>CONTROL
echo %DAT%                   >>CONTROL
echo .\                      >>CONTROL
echo tdump                   >>CONTROL

REM ---------------------------------------

IF EXIST SETUP.CFG DEL SETUP.CFG
IF EXIST tdump DEL tdump
%PGM%\exec\hyts_std

ECHO 'TITLE^&','### %0: simple ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -itdump -v0 -z80 -j%PGM%\graphics\arlmap
trajplot.html
PAUSE

%PGM%\exec\latlon
%PGM%\exec\hyts_std

ECHO 'TITLE^&','### %0: matrix ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -itdump -v0 -z80 -j%PGM%\graphics\arlmap
trajplot.html
