@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------

SET SYR=83
SET SMO=09
SET SDA=01
SET SHR=00
     
SET LAT=45.0
SET LON=-125.0
SET LVL=750.0
        
SET RUN=72
SET TOP=10000.0
SET MET=%WRK%\captex
SET DAT=RP198309.gbl

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL
echo 1                       >>CONTROL
echo %LAT% %LON% %LVL%       >>CONTROL
echo %RUN%                   >>CONTROL
echo 1                       >>CONTROL
echo %TOP%                   >>CONTROL
echo 1                       >>CONTROL
echo %MET%\                  >>CONTROL
echo %DAT%                   >>CONTROL
echo .\                      >>CONTROL
echo fdump                   >>CONTROL

REM ---------------------------------------

echo ^&SETUP                >SETUP.CFG
echo tm_terr=1,            >>SETUP.CFG
echo /                     >>SETUP.CFG

IF EXIST fdump DEL fdump

%PGM%\exec\hyts_std

ECHO 'TITLE^&','### %0: forward ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -ifdump -v1 -z80 -j%PGM%\graphics\arlmap
trajplot.html
PAUSE

FOR /F "tokens=10,11,12" %%J IN (fdump) do (
SET LAT=%%J
SET LON=%%K
SET LVL=%%L
)

SET SDA=04
SET SHR=00

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL
echo 1                       >>CONTROL
echo %LAT% %LON% %LVL%       >>CONTROL
echo -%RUN%                  >>CONTROL
echo 1                       >>CONTROL
echo %TOP%                   >>CONTROL
echo 1                       >>CONTROL
echo %MET%\                  >>CONTROL
echo %DAT%                   >>CONTROL
echo .\                      >>CONTROL
echo bdump                   >>CONTROL

REM ---------------------------------------

IF EXIST bdump DEL bdump

%PGM%\exec\hyts_std

ECHO 'TITLE^&','### %0: with backward ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -ibdump -v1 -z80 -j%PGM%\graphics\arlmap
trajplot.html

PAUSE

ECHO 'TITLE^&','### %0: with backward ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -ifdump+bdump -v1 -z80 -j%PGM%\graphics\arlmap
trajplot.html

