@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
     
SET LAT=39.90
SET LON=-84.22
SET LVL=600.0
        
SET RUN=68
SET TOP=10000.0
SET MET=%WRK%\captex

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL1
echo 1                       >>CONTROL1
echo %LAT% %LON% %LVL%       >>CONTROL1
echo %RUN%                   >>CONTROL1
echo 0                       >>CONTROL1
echo %TOP%                   >>CONTROL1
echo 1                       >>CONTROL1
echo %MET%\                  >>CONTROL1

REM ---------------------------------------

IF EXIST tdump_narr   DEL tdump_narr
IF EXIST tdump_wrf27  DEL tdump_wrf27
IF EXIST SETUP.CFG DEL SETUP.CFG

COPY CONTROL1 CONTROL
echo captex2_wrf27uw.bin >>CONTROL
echo .\                  >>CONTROL
echo tdump_wrf27         >>CONTROL
%PGM%\exec\hyts_std

COPY CONTROL1 CONTROL
echo captex2_narr.bin    >>CONTROL
echo .\                  >>CONTROL
echo tdump_narr          >>CONTROL
%PGM%\exec\hyts_std
DEL CONTROL1

ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -itdump_wrf27+tdump_narr -z25 -v0 -j%PGM%\graphics\arlmap
trajplot.html

