@echo off
setLocal EnableDelayedExpansion

REM #################################################
REM # Adapted from \hysplit\testing\xcluster.bat   #
REM #################################################

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF NOT EXIST fdump83090100 (
   IF NOT EXIST fdump83092818 (
      echo trajectory endpoint {fdump} files missing, rerun previous batch file
      pause
   )
)

REM set final number of clusters -------------------

SET ilab1=traj_clus
SET nc=6		

REM section 1 --------------------------------------

dir /b fdump???????? >INFILE

SET dur=48
SET int=1
SET skip=1
SET ODIR=.\
SET PROJ=0
   
ECHO %dur%   > CCONTROL
ECHO %int%  >> CCONTROL 
ECHO %skip% >> CCONTROL 
ECHO %ODIR% >> CCONTROL
ECHO %PROJ% >> CCONTROL

%PGM%\exec\cluster 
DEL TNOCLUS TCLUS

REM section 2 --------------------------------------

SET  mint=15  
SET  minc=3  
SET  maxc=10
SET  pct=30 
        
REM # TSV plot
%PGM%\exec\clusplot +g1 -iDELPCT -oclusplot.html -l%ilab1%
clusplot.html
PAUSE
      
REM # determine final number of clusters
%PGM%\exec\clusend -iDELPCT -n%minc% -a%maxc% -t%mint% -p%pct% -oCLUSEND

REM # generate list of trajs in each cluster
%PGM%\exec\cluslist -iCLUSTER -n%nc% -oCLUSLIST_%nc%

REM # add trajs not clustered (cluster #0) to CLUSLIST
IF EXIST CLUSTERno (
   TYPE CLUSLIST_%nc% >> CLUSTERno
   DEL CLUSLIST_%nc%
   IF EXIST CLUSTERno RENAME CLUSTERno CLUSLIST_%nc%
)

REM # create TRAJ.INP.Cxx file for each cluster (list of trajs) 
%PGM%\exec\clusmem -iCLUSLIST_%nc%

for %%N in (1 2 3 4 5) do (
    %PGM%\exec\merglist -i+TRAJ.INP.C%%N_%nc% -omdump -ptdump
    IF EXIST mdump.tdump RENAME mdump.tdump C%%N.tdump
    %PGM%\exec\trajmean -i+TRAJ.INP.C%%N_%nc% 
    IF EXIST tmean RENAME tmean C%%Nmean.tdump
)

IF EXIST MEAN.LIST DEL MEAN.LIST
for %%N in (1 2 3 4 5) do (
    ECHO C%%Nmean.tdump  >> MEAN.LIST
)

%PGM%\exec\merglist -i+MEAN.LIST -omdump -ptdump
IF EXIST mdump.tdump RENAME mdump.tdump Cmean.tdump
DEL MEAN.LIST

REM section 3 --------------------------------------

for %%N in (1 2 3 4 5 6) do (
    ECHO 'TITLE^&','TRAJECTORIES IN CLUSTER %%N of %nc% Example^&' > LABELS.CFG
    %PGM%\exec\trajplot +g1 -iC%%N.tdump -e%dur% -z80 -k0 -l0 -v4 
    IF EXIST trajplot_C%%N.html DEL trajplot_C%%N.html
    IF EXIST trajplot.html RENAME trajplot.html trajplot_C%%N.html
    trajplot_C%%N.html
    PAUSE
)

SET tmout=Cmean.tdump 
ECHO 'TITLE^&','CLUSTER MEAN TRAJECTORIES %ilab1%^&' > LABELS.CFG
%PGM%\exec\trajplot +g1 -i%tmout% -e%dur% -z80 -k%nc%:12345 -l-12 -v4
IF EXIST trajplot_MEAN.html DEL trajplot_MEAN.html
IF EXIST trajplot.html RENAME trajplot.html trajplot_MEAN.html
trajplot_MEAN.html

REM section 4 cleanup --------------------------------------

REM DEL TCLUS TNOCLUS CLUSTER DELPCT CLUSTERno CMESSAGE
REM DEL INFILE CCONTROL LABELS.CFG
REM DEL *.tdump
REM DEL TRAJ.INP*
REM DEL CLUSLIST_* CLUSEND
