@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM rerun model -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=01
SET SHR=00
    
SET LAT=43.0 
SET LON=-75.0  
SET LVL=10.0

SET RUN=60
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=RP198309.gbl         
SET INP=srm.bin      
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 3                      >>CONTROL
echo 40.0 -78.0 %LVL%       >>CONTROL
echo 45.0 -70.0 %LVL%       >>CONTROL
echo 40.5 -77.5 %LVL%       >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 1.0                    >>CONTROL
echo 60.0                   >>CONTROL
echo 83 09 01 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 41.0 -73.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 01 00 00         >>CONTROL
echo 83 09 03 12 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo ichem = 1,           >>SETUP.CFG
echo khmax = 30,          >>SETUP.CFG
echo numpar = 500000,     >>SETUP.CFG
echo maxpar = 300000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM -------------------------------------------

%PGM%\exec\latlon
IF NOT EXIST %INP% %PGM%\exec\hycs_std

REM -------------------------------------------

IF EXIST sumstat.txt DEL sumstat.txt

set RUN=1
IF EXIST CONTROL (
   FOR /F "tokens=1,2 skip=1" %%P IN (CONTROL) do (
       IF !RUN! EQU 1 (
          set /a MAX=%%P+1
          echo !MAX!
       ) ELSE (
          IF !RUN! LEQ !MAX! (
             echo %%P %%Q
             %PGM%\exec\matrix   -i%INP% -oSRM_cdump -y%%P -x%%Q -ms
             %PGM%\exec\c2datem  -iSRM_cdump -ohysplit.txt -c1.0E+15 -m%MET%\hypo_meas.txt -xi -s
             %PGM%\exec\statmain -t0 -rhysplit.txt -d%MET%\hypo_meas.txt -o1 -ssumstat.txt
          )
       )
      set /a RUN=!RUN!+1
   )
)

%PGM%\exec\stat2grid -isumstat.txt -ostatmap.bin -v3
echo 'TITLE^&','### %0: spatial statistics for CC ### ^&'  >LABELS.CFG
echo 'UNITS^&',' ^&' >>LABELS.CFG
echo 'VOLUM^&',' ^&' >>LABELS.CFG

IF EXIST griplot.html DEL gridplot.html
%PGM%\exec\gridplot +g1 -istatmap.bin -j%MAP% -ogridplot.html -l0.0 -d0.05 -a0 -c1.0
gridplot.html
PAUSE

TYPE sumstat.txt
PAUSE

%PGM%\exec\matrix   -i%INP% -oSRM_cdump -y43.0 -x-75.0 -ms
%PGM%\exec\c2datem  -iSRM_cdump -ohysplit.txt -c1.0E+15 -m%MET%\hypo_meas.txt -xi 
%PGM%\exec\statmain -t0 -rhysplit.txt -d%MET%\hypo_meas.txt -o1 

TYPE statA.txt
PAUSE

ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\scatter +g1 -idataA.txt -p10.0
scatter.html


