@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM rerun model -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=01
SET SHR=00
    
SET LAT=43.0 
SET LON=-75.0 
SET LVL=10.0

SET RUN=60 
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=RP198309.gbl         
SET INP=srm.bin 
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 3                      >>CONTROL
echo 40.0 -78.0 %LVL%       >>CONTROL
echo 45.0 -70.0 %LVL%       >>CONTROL
echo 40.5 -77.5 %LVL%       >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 1.0                    >>CONTROL
echo 60.0                   >>CONTROL
echo 83 09 01 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 41.0 -73.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 01 00 00         >>CONTROL
echo 83 09 03 12 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo ichem = 1,           >>SETUP.CFG
echo khmax = 30,          >>SETUP.CFG
echo numpar = 500000,     >>SETUP.CFG
echo maxpar = 300000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM -------------------------------------------

%PGM%\exec\latlon
IF EXIST %INP% DEL %INP%
%PGM%\exec\hycs_std

%PGM%\exec\matrix -i%INP% -oSRM_fwrd.bin -y43.0 -x-75.0 -ms
echo 'TITLE^&','### %0: contributions from source ### ^&'  >LABELS.CFG
echo 'MAPID^&','Air Concentration ^&' >>LABELS.CFG

IF EXIST concplot.html DEL concplot.html
%PGM%\exec\concplot +g1 -k1 -z80 -j%MAP% -iSRM_fwrd.bin
concplot.html
PAUSE

%PGM%\exec\matrix -i%INP% -oSRM_back.bin -y44.0 -x-70.0 -mr
echo 'TITLE^&','### %0: sources contributing to receptor ### ^&'  >LABELS.CFG
echo 'MAPID^&','Air Concentration ^&' >>LABELS.CFG

IF EXIST concplot.html DEL concplot.html
%PGM%\exec\concplot +g1 -k1 -z80 -j%MAP% -iSRM_back.bin
concplot.html
