@echo off
setLocal EnableDelayedExpansion

SET /P Q=Enter 0 for measurement weight or 1 for inverse emissions:

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM rerun model -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=01
SET SHR=00
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=60
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=RP198309.gbl 

IF %Q% == 0 (
   SET INP=cnum     
) ELSE (
   SET INP=cden     
)

IF EXIST CONTROL.001 DEL CONTROL.???
IF EXIST %INP%.001 DEL %INP%.???
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 0.0                    >>CONTROL
echo 60.0                   >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 41.0 -73.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 01 00 00         >>CONTROL
echo 83 09 03 12 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 5000,       >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM -------------------------------------------

%PGM%\exec\dat2cntl -i%MET%\hypo_meas.txt -d%Q% -c1.0

set RUN=1
:loop
IF !RUN! LSS 1000 (
   SET NUM=!RUN!
   IF !RUN! LSS 100 SET NUM=0!RUN!
   IF !RUN! LSS 10 SET NUM=00!RUN!
   
   IF EXIST CONTROL.!NUM! (
      echo !NUM! 
      COPY SETUP.CFG SETUP.!NUM!
      %PGM%\exec\hycs_std !NUM!
      DEL MESSAGE.!NUM! VMSDIST.!NUM! WARNING.!NUM! CONTROL.!NUM! CONC.!NUM! SETUP.!NUM!
   )
   set /a RUN=!RUN!+1
GOTO loop
)

IF EXIST cmean DEL cmean
%PGM%\exec\conprob -b%INP% -t20 -v0.0  

IF %Q% == 0 (
echo 'TITLE^&','### %0: Source Sensitivity ### ^&'  >LABELS.CFG
) ELSE (
echo 'TITLE^&','### %0: Inverse Emissions ### ^&'  >LABELS.CFG
)

echo 'UNITS^&',' mass ^&'     >>LABELS.CFG
echo 'VOLUM^&',' ^&'          >>LABELS.CFG
echo 'MAPID^&',' Receptor ^&' >>LABELS.CFG

IF EXIST concplot.html DEL concplot.html
%PGM%\exec\concplot +g1 -m0 -k1 -z80 -j%MAP% -icmean
concplot.html
