@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM rerun model ------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=01
SET SHR=00
    
SET LAT=43.0  
SET LON=-75.0  
SET LVL=10.0

SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=RP198309.gbl   

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 10000,      >>SETUP.CFG
echo maxpar = 20000,      >>SETUP.CFG
echo /                    >>SETUP.CFG

REM ------------------------------------------

IF EXIST INFILE DEL INFILE
        
SET RUN=72
for %%D in (01 02 03) do (
for %%H in (00 12) do (

set /a RUN=!RUN!-12

echo %SYR% %SMO% %%D %%H     >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo !RUN!                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 1.0                    >>CONTROL
echo 12.0                   >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 41.0 -73.0             >>CONTROL
echo 0.10 0.10              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo tcm%SMO%%%D%%H         >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 01 00 00         >>CONTROL
echo 83 09 03 12 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST tcm%SMO%%%D%%H DEL tcm%SMO%%%D%%H
IF !RUN! GEQ 12 ( 
   %PGM%\exec\hycs_std
   echo tcm%SMO%%%D%%H >>INFILE
)

)
)

REM ------- convert HYSPLIT unit source files to TCM in CSV format ---------

IF EXIST c2array.txt DEL c2array.txt 
%PGM%\exec\c2array -c1.0E+12 -iINFILE -m%MET%\hypo_meas.txt -oc2array.csv >c2array.txt
type c2array.csv
PAUSE

REM number of rows (measurements) and columns (sources) in matrix
set row=0
set col=0
IF EXIST c2array.txt (
   FOR /F "tokens=5,6" %%A IN (c2array.txt) do (
   set row=%%A
   set col=%%B
)
)

REM ------- create namelist file of input parameters for solver -------------

REM source term first guess
set guess=1000.0

REM convert source (X) to log or TCM (Y) to log
set LNX=.false.
set LNY=.true.

REM solution unbounded and apply scaling factor
set bound=0
set Xscale=1.0

REM observational data uncertainty: fraction and fixed
set uof=1.0
set uoa=0.1

REM source term uncertainty: fraction and fixed
set ubf=1.0
set uba=0.1

echo ^&DIMENSIONS              >PARAMETER_IN_000
echo  N_ctrl = %col%,         >>PARAMETER_IN_000
echo  Nx_ctrl = %col%,        >>PARAMETER_IN_000
echo  Ny_ctrl = 1,            >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

echo ^&TCM_INPUTS             >>PARAMETER_IN_000
echo  CSV_IN = 'c2array.csv', >>PARAMETER_IN_000
echo  N_obs = %row%,          >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

echo ^&RUN_CONTRL             >>PARAMETER_IN_000
echo  bckg_const = %guess%,   >>PARAMETER_IN_000
echo  APRIORI = 'in.dat',     >>PARAMETER_IN_000
echo  LN_X = %LNX%,           >>PARAMETER_IN_000
echo  LN_Y = %LNY%,           >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000
  
echo ^&SMOOTH_PNT             >>PARAMETER_IN_000
echo  Smoother=.true.,        >>PARAMETER_IN_000
echo  c_smooth=1D-6,          >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

echo ^&SMOOTH_P2D             >>PARAMETER_IN_000
echo  Smooth2D=.false.,       >>PARAMETER_IN_000
echo  x_smooth=1.0,           >>PARAMETER_IN_000
echo  y_smooth=1.0,           >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

echo ^&MODEL_UNC              >>PARAMETER_IN_000
echo  UNC_Model=.false.,      >>PARAMETER_IN_000
echo  T_model_unc=1.0,        >>PARAMETER_IN_000
echo  Floor_x=1.0,            >>PARAMETER_IN_000
echo  Ceiling_x=1.0,          >>PARAMETER_IN_000
echo  Floor_y=1.0,            >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

echo ^&LBFGS_CTRL             >>PARAMETER_IN_000
echo  lbfgs_m = 7,            >>PARAMETER_IN_000
echo  lbfgs_iprint=1,         >>PARAMETER_IN_000
echo  lbfgs_factor=1.,        >>PARAMETER_IN_000
echo  lbfgs_pgtol=1.0d-36,    >>PARAMETER_IN_000
echo  Max_iterations=500,     >>PARAMETER_IN_000
echo  f_factor_stop=1e-16,    >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

echo ^&BOUNDS_ARR             >>PARAMETER_IN_000
echo  lbfgs_nbd_c=%bound%,    >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

echo ^&UNCERTANTY             >>PARAMETER_IN_000
echo   X_Scaling=%Xscale%,    >>PARAMETER_IN_000
echo   Unc_o_f=%uof%,         >>PARAMETER_IN_000
echo   Unc_o_a=%uoa%,         >>PARAMETER_IN_000
echo   Unc_b_f=%ubf%,         >>PARAMETER_IN_000
echo   Unc_b_a=%uba%,         >>PARAMETER_IN_000
echo /                        >>PARAMETER_IN_000

REM --------- cost function minimization solution -------------

IF EXIST SOURCE_OUT_000 DEL SOURCE_OUT_000
%PGM%\exec\lbfgsb.exe 000 >LOG_cost.txt
ECHO Cost Function Solution
type SOURCE_OUT_000

SET /P Q=Press any key to continue . . .

