@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM rerun model -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=01
SET SHR=00
    
SET LAT=43.0  
SET LON=-75.0  
SET LVL=10.0

SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=RP198309.gbl  

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 10000,      >>SETUP.CFG
echo maxpar = 20000,      >>SETUP.CFG
echo /                    >>SETUP.CFG

REM ------------------------------------------

IF EXIST INFILE DEL INFILE
        
SET RUN=72
for %%D in (01 02 03) do (
for %%H in (00 12) do (

set /a RUN=!RUN!-12  

echo %SYR% %SMO% %%D %%H    >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo !RUN!                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 1.0                    >>CONTROL
echo 12.0                   >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 41.0 -73.0             >>CONTROL
echo 0.10 0.10              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo tcm%SMO%%%D%%H         >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 01 00 00         >>CONTROL
echo 83 09 03 12 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST tcm%SMO%%%D%%H DEL tcm%SMO%%%D%%H
IF !RUN! GEQ 12 (
   %PGM%\exec\hycs_std
   echo tcm%SMO%%%D%%H >>INFILE
)

)
)

REM ------------------------------------------

IF EXIST c2array.txt DEL c2array.txt 
%PGM%\exec\c2array -c1.0E+12 -iINFILE -m%MET%\hypo_meas.txt -oc2array.csv >c2array.txt
type c2array.csv
pause

%PGM%\exec\tcsolve -ic2array.csv -otcsolve.dat -z0.0
type tcsolve.dat

SET /P Q=Press any key to continue . . .
