@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap
SET INP=hysplit2.bin

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=11
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------------
       
echo %SYR% %SMO% %SDA% %SHR% >CONTROL1
echo 1                      >>CONTROL1
echo %LAT% %LON% %LVL%      >>CONTROL1
echo %RUN%                  >>CONTROL1
echo 0                      >>CONTROL1
echo %TOP%                  >>CONTROL1
echo 1                      >>CONTROL1
echo %MET%\                 >>CONTROL1

echo 1                       >CONTROL2
echo PMCH                   >>CONTROL2
echo 67000.0                >>CONTROL2
echo 3.0                    >>CONTROL2
echo 00 00 00 00 00         >>CONTROL2
echo 1                      >>CONTROL2
echo 42.0 -78.0             >>CONTROL2
echo 0.05 0.05              >>CONTROL2
echo 15.0 25.0              >>CONTROL2
echo .\                     >>CONTROL2
echo %INP%                  >>CONTROL2
echo 2                      >>CONTROL2
echo 800 1000               >>CONTROL2
echo 83 09 26 03 00         >>CONTROL2
echo 83 09 28 15 00         >>CONTROL2
echo 00 01 00               >>CONTROL2
echo 1                      >>CONTROL2
echo 0.0 0.0 0.0            >>CONTROL2
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL2
echo 0.0 0.0 0.0            >>CONTROL2
echo 0.0                    >>CONTROL2
echo 0.0                    >>CONTROL2

COPY CONTROL1   CONTROL
echo %DAT%    >>CONTROL
TYPE CONTROL2 >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo initd = 3,           >>SETUP.CFG
echo kblt = 2,            >>SETUP.CFG
echo kmsl = 1,            >>SETUP.CFG
echo numpar = 5000,       >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo idsp = 2,            >>SETUP.CFG
echo wvert = .false.,      >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST %INP% DEL %INP%
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0: STILT Dispersion ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -i%INP% -z80 -j%MAP% -x1.0E+12 -upg -h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q%WRK%\captex\data_case.txt 
concplot.html
PAUSE

REM -------------------------------------------

SET DAT=captex2_wrf27mc.bin
COPY CONTROL1   CONTROL
echo %DAT%    >>CONTROL
TYPE CONTROL2 >>CONTROL

IF EXIST %INP% DEL %INP%
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0: Mass-Coupled Winds ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -i%INP% -z80 -j%MAP% -x1.0E+12 -upg -h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q%WRK%\captex\data_case.txt 
concplot.html
PAUSE

REM -------------------------------------------

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo initd = 3,           >>SETUP.CFG
echo kblt = 2,            >>SETUP.CFG
echo kmsl = 1,            >>SETUP.CFG
echo numpar = 5000,       >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo idsp = 2,            >>SETUP.CFG
echo wvert = .true.,      >>SETUP.CFG
echo /                    >>SETUP.CFG


IF EXIST %INP% DEL %INP%
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0: WRF Vertical Interpolation ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -i%INP% -z80 -j%MAP% -x1.0E+12 -upg -h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q%WRK%\captex\data_case.txt 
concplot.html
