@echo off
REM setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=12
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM ------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo TEST                   >>CONTROL
echo 100.0                  >>CONTROL
echo 0.01                   >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0                >>CONTROL
echo 0.005 0.005            >>CONTROL
echo 30.0 30.0              >>CONTROL
echo .\                     >>CONTROL
echo cdump                  >>CONTROL
echo 1                      >>CONTROL
echo 5000                   >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 01 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

REM --------------------------------------------

echo ^&SETUP            >SETUP.CFG
echo numpar = 10000,   >>SETUP.CFG
echo ndump = 3,        >>SETUP.CFG
echo ncycl = 3,        >>SETUP.CFG
echo /                 >>SETUP.CFG

IF EXIST cdump DEL cdump
IF EXIST PARDUMP DEL PARDUMP
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: cross-section ### ^&' >LABELS.CFG
%PGM%\exec\parxplot +g1 -iPARDUMP -k1 -z80 -j%PGM%\graphics\arlmap
parxplot.html
PAUSE

ECHO 'TITLE^&','### %0: plane-view ### ^&' >LABELS.CFG
%PGM%\exec\parhplot +g1 -iPARDUMP -k1 -z80 -j%PGM%\graphics\arlmap
parhplot.html
PAUSE

ECHO 'TITLE^&','### %0: vertical projection ### ^&' >LABELS.CFG
%PGM%\exec\parvplot +g1 -iPARDUMP -k1 -z80 -j%PGM%\graphics\arlmap
parvplot.html

REM --------------------------------------------

echo ^&SETUP                >SETUP.CFG
echo numpar = 10000,       >>SETUP.CFG
echo cmtfn = 'cmtraj.txt', >>SETUP.CFG
echo /                     >>SETUP.CFG

IF EXIST cdump DEL cdump
%PGM%\exec\hycs_std

%PGM%\exec\trajplot +g1 -icmtraj.txt -j%PGM%\graphics\arlmap -m0 -k1 -l1 -z10 -v1 -a0 -s1
trajplot.html

REM "%HOMEPATH%\Anaconda3\envs\hysplit\Scripts\activate.bat" "%HOMEPATH%\Anaconda3\envs\hysplit" && python.exe "%PGM%\exec\trajplot.py" --interactive -icmtraj.txt -otrajplot.html -j%PGM%\graphics\arlmap -m0 -k1 -l1 -z10 -v1 -a0 -s1
 
