@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap
SET INP=hysplit2.bin

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------------

echo '%WRK%\maps\roads.shp'  0 0.005 0.8 0.7 0.5  >shapefiles.txt
echo '%WRK%\maps\county.shp' 0 0.010 0.4 0.6 0.8 >>shapefiles.txt
echo '%WRK%\maps\states.shp' 0 0.015 0.2 0.2 0.5 >>shapefiles.txt

REM -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=11
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------------

echo ^&SETUP               >SETUP.CFG
echo numpar = 5000,       >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo initd = 3,           >>SETUP.CFG
echo kmsl = 1,            >>SETUP.CFG
echo /                    >>SETUP.CFG
       
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 67000.0                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.05 0.05              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 2                      >>CONTROL
echo 800 1000               >>CONTROL
echo 83 09 26 03 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 01 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

REM -----------------------------------------------

IF EXIST %INP% DEL %INP%
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0: base plume result ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -i%INP% -a1 -z10 -jshapefiles.txt -x1.0E+12 -upg -c4 -b1000 -t1000 -v50000+20000+10000+5000+2000+1000
concplot.html
PAUSE

REM -------------------------------------------------

IF EXIST GIS_01000_html_01.txt (
     IF EXIST concplot.shp DEL concplot.???
     %PGM%\exec\ascii2shp -d concplot polygons <GIS_01000_html_01.txt
     %PGM%\exec\txt2dbf -C11 -C5 -C9 -C5 -C6../ -C6 -d,  GIS_01000_html_01.att concplot.dbf
)
DEL GIS_01000_html_01.???

REM -----------------------------------------------

echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% 750.0      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo .\                     >>CONTROL
echo tdump_fwrd             >>CONTROL

IF EXIST tdump_fwrd DEL tdmp_????
IF EXIST SETUP.CFG DEL SETUP.CFG
%PGM%\exec\hyts_std    

IF EXIST trajplot.html DEL trajplot.html
ECHO 'TITLE^&','### %0: base trajectory result ### ^&' >LABELS.CFG

%PGM%\exec\trajplot +g1 -jshapefiles.txt -itdump_fwrd -a5 -k1 -z10 -l1 -v0
trajplot.html
PAUSE

REM -----------------------------------------------

IF EXIST GIS_traj_html_01.txt (
   IF EXIST trajplot.shp DEL trajplot.???
   %PGM%\exec\ascii2shp -d trajplot lines <GIS_traj_html_01.txt
   %PGM%\exec\txt2dbf -C7 -C9 -C5 -C9 -d, -d, -d, GIS_traj_html_01.att trajplot.dbf
)

REM -----------------------------------------------

echo '%WRK%\maps\states.shp' 0 0.015 0.2 0.2 0.5  >shapefiles.txt
echo 'concplot.shp' 0 0.010 0.4 0.6 0.8          >>shapefiles.txt
echo 'TITLE^&','### %0: base trajectory with plume ### ^&'  >LABELS.CFG

%PGM%\exec\trajplot -jshapefiles.txt -itdump_fwrd -k1 -z10 -l1 -v0
trajplot.html
PAUSE

DEL LABELS.CFG shapefiles.txt

echo '%WRK%\maps\states.shp' 0 0.015 0.2 0.2 0.5  >shapefiles.txt
echo 'trajplot.shp' 0 0.010 0.0 0.0 0.0          >>shapefiles.txt
echo 'TITLE^&','### %0: base plume with trajectory ### ^&'  >LABELS.CFG
%PGM%\exec\concplot +g1 -jshapefiles.txt -i%INP% -k1 -z10 -x1.0E+12 -upg -c4 -b1000 -t1000 -v50000+20000+10000+5000+2000+1000
concplot.html
