@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap
SET INP=hysplit2.bin

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=11
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------------
       
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 67000.0                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.05 0.05              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 2                      >>CONTROL
echo 800 1000               >>CONTROL
echo 83 09 26 00 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 01 01 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

echo ^&SETUP               >SETUP.CFG
echo kmsl = 1,            >>SETUP.CFG
echo initd = 3,           >>SETUP.CFG
echo numpar = 5000,       >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

echo 1                    >LAGSET.CFG
echo 40.86 -81.81 914.0  >>LAGSET.CFG
echo 290.0 50.0          >>LAGSET.CFG
echo 83 09 26 02 48      >>LAGSET.CFG
echo 83 09 26 02 48      >>LAGSET.CFG
echo 06                  >>LAGSET.CFG
echo 06                  >>LAGSET.CFG
echo 'LAGOUT.TXT'        >>LAGSET.CFG

REM -----------------------------------------------
REM only text output, no graphics

IF EXIST %INP% DEL %INP%
IF EXIST LAGOUT.TXT DEL LAGOUT.TXT
%PGM%\exec\hycs_std

type LAGOUT.TXT
ECHO             

ECHO Continue to delete LAGSET.CFG
PAUSE
IF EXIST LAGSET.CFG DEL LAGSET.CFG
