@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=11
SET SMO=03
SET SDA=14
SET SHR=00

SET LAT=37.4206
SET LON=141.0329
SET LVL=100.0
    
SET RUN=196
SET TOP=10000.0

SET MET=%WRK%\japan
SET DAT=RP201103.bin
REM SET DAT=gdas11-22.bin

REM -------------------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo I131                   >>CONTROL
echo 5.0E+15                >>CONTROL
echo 24.0                   >>CONTROL
echo 11 03 14 12 00         >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0                >>CONTROL
echo 1.0 1.0                >>CONTROL
echo 181.0 360.0            >>CONTROL
echo .\                     >>CONTROL
echo fukushima.bin          >>CONTROL
echo 1                      >>CONTROL
echo 500                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 00 24 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.01 0.0 0.0 0.0 0.0   >>CONTROL
echo 3.0 0.0 0.0            >>CONTROL
echo 8.04                   >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo delt = 30.0,         >>SETUP.CFG
echo numpar = 24000,      >>SETUP.CFG
echo maxpar = 25000,      >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST fukushima.bin DEL fukushima.bin
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -ifukushima.bin -j%PGM%\graphics\arlmap -x1000.0 -umBq
concplot.html
PAUSE

echo DHAK 53.9 -166.5 >samplers.txt
%PGM%\exec\con2stn -ifukushima.bin -ocon2stn.txt -c1000.0 -r1 -ssamplers.txt
type con2stn.txt
PAUSE

copy %MET%\LABELS.CFG .
%PGM%\exec\timeplot +g1 -icon2stn.txt -s%MET%\Dutch_Harbor.txt
timeplot.html


