@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=10
SET SMO=03
SET SDA=30
SET SHR=00
    
SET RUN=30
SET TOP=10000.0

SET MET=%WRK%\dust
SET DAT=WRF201003.bin

REM -------------------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 21                     >>CONTROL
echo 38.50 -114.00 10.0  72.0 0.575E+04 >>CONTROL
echo 38.50 -113.75 10.0  66.3 0.352E+04 >>CONTROL
echo 38.50 -113.25 10.0  67.4 0.739E+04 >>CONTROL
echo 38.50 -113.00 10.0  66.6 0.353E+04 >>CONTROL
echo 38.75 -114.00 10.0  55.1 0.395E+04 >>CONTROL
echo 38.75 -113.75 10.0  47.3 0.326E+04 >>CONTROL
echo 38.75 -113.50 10.0  66.4 0.261E+04 >>CONTROL
echo 38.75 -113.00 10.0  74.8 0.166E+05 >>CONTROL
echo 39.00 -114.00 10.0  59.9 0.759E+04 >>CONTROL
echo 39.00 -113.75 10.0  47.3 0.429E+04 >>CONTROL
echo 39.00 -113.50 10.0  56.8 0.361E+04 >>CONTROL
echo 39.25 -114.00 10.0  50.9 0.579E+04 >>CONTROL
echo 39.25 -113.75 10.0  49.9 0.516E+04 >>CONTROL
echo 39.25 -113.50 10.0  53.9 0.418E+04 >>CONTROL
echo 39.25 -113.25 10.0  54.6 0.643E+04 >>CONTROL
echo 39.25 -113.00 10.0  76.6 0.535E+04 >>CONTROL
echo 39.50 -114.00 10.0  56.7 0.654E+04 >>CONTROL
echo 39.50 -113.75 10.0  49.3 0.684E+04 >>CONTROL
echo 39.50 -113.50 10.0  44.8 0.599E+04 >>CONTROL
echo 39.50 -113.25 10.0  55.2 0.365E+04 >>CONTROL
echo 39.50 -113.00 10.0  75.1 0.263E+05 >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PM10                   >>CONTROL
echo 0.0                    >>CONTROL
echo %RUN%                  >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0                >>CONTROL
echo 0.05 0.05              >>CONTROL
echo 30.0 30.0              >>CONTROL
echo .\                     >>CONTROL
echo dust2.bin              >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 00 00 00 06 00         >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 00 24 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo ichem = 3,           >>SETUP.CFG
echo numpar = 100000,     >>SETUP.CFG
echo maxpar = 50000,      >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST dust2.bin DEL dust2.bin
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0: variable threshold ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -idust2.bin -z90 -j%PGM%\graphics\arlmap -x1.0E+06 -c4 -uug -v500+200+100+50+20+10 -g0:400 -h40.00:-112.00
concplot.html
PAUSE

%PGM%\exec\c2datem -xi -idust2.bin -c1.0E+06 -m%MET%\AirNow_dust.txt -ohysplit.txt
%PGM%\exec\statmain -t0 -rhysplit.txt -d%MET%\AirNow_dust.txt -l10.0 -o1
type statA.txt
PAUSE

%PGM%\exec\scatter +g1 -idataA.txt -p10.0
scatter.html
