@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=11
SET SMO=03
SET SDA=11
SET SHR=12

SET LAT=37.4206
SET LON=141.0329
SET LVL=100.0
    
SET RUN=108
SET TOP=10000.0

SET MET=%WRK%\japan
SET DAT=gdas11-22.bin

REM -------------------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 2                      >>CONTROL
echo RNUC                   >>CONTROL
echo 1.0                    >>CONTROL
echo 24.0                   >>CONTROL
echo 11 03 14 12 00         >>CONTROL
echo NGAS                   >>CONTROL
echo 1.0                    >>CONTROL
echo 24.0                   >>CONTROL
echo 11 03 14 12 00         >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0                >>CONTROL
echo 0.05 0.05              >>CONTROL
echo 10.0 10.0              >>CONTROL
echo .\                     >>CONTROL
echo fukushima.bin          >>CONTROL
echo 2                      >>CONTROL
echo 0 500                  >>CONTROL
echo 11 03 14 12 00         >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 00 36 00               >>CONTROL
echo 2                      >>CONTROL
echo 1.0 1.0 1.0            >>CONTROL
echo 0.001 0.0 0.0 0.0 0.0  >>CONTROL
echo 0.0 8.0E-05 8.0E-05    >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo maxdim = 2,          >>SETUP.CFG
echo numpar = 12000,      >>SETUP.CFG
echo maxpar = 12000,      >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST fukushima.bin DEL fukushima.bin
%PGM%\exec\hycs_std

IF EXIST activity.txt DEL activity.txt
IF EXIST dose.bin DEL dose.bin
%PGM%\exec\con2rem -afdnpp >con2rem.log
%PGM%\exec\con2rem -aactivity.txt -ifukushima.bin -odose.bin -y1.0 -w0.0 -c0 -d1 -t1 -s0 -x0 -q1 >>con2rem.log

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0: Radiological Dose ### ^&' >LABELS.CFG
ECHO 'MAPID^&','Accumulated Dose ^&'             >>LABELS.CFG
ECHO 'UNITS^&','mSv ^&'                          >>LABELS.CFG
ECHO 'VOLUM^&',' ^&'                             >>LABELS.CFG

%PGM%\exec\concplot +g1 -idose.bin -j%PGM%\graphics\arlmap -k2 -z95 -s0 -g0:250 -x1000.0 -y1000.0 -v100+50+20+5+2+1+0.5+0.2+0.1
concplot.html

