@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=25
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo C137                   >>CONTROL
echo 1.0E+16                >>CONTROL
echo 1.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo c137.bin               >>CONTROL
echo 2                      >>CONTROL
echo 0 100                  >>CONTROL
echo 83 09 25 18 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 1.0 1.0 1.0            >>CONTROL
echo 0.001 0.0 0.0 0.0 0.0  >>CONTROL
echo 0.0 8.0E-05 8.0E-05    >>CONTROL
echo 10960.0                >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 50000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM ---------------------------------------------------

IF EXIST c137.bin DEL c137.bin
%PGM%\exec\hycs_std

IF EXIST dosedaily.html DEL dosedaily.html
ECHO 'TITLE^&','### %0 ### ^&'      >LABELS.CFG
ECHO 'UNITS^&','REM^&'             >>LABELS.CFG
ECHO 'VOLUM^&','   ^&'             >>LABELS.CFG
ECHO 'MAPID^&','24-h Dose Equivalent^&' >>LABELS.CFG
%PGM%\exec\concplot +g1 -ic137.bin -z80 -x1.0E-10 -y2.6E-11 -b0 -t100 -r3 -j%PGM%\graphics\arlmap -odosedaily
dosedaily.html

PAUSE

IF EXIST doseyear.html DEL doseyear.html
ECHO 'TITLE^&','### %0 ### ^&'      >LABELS.CFG
ECHO 'UNITS^&','REM^&'             >>LABELS.CFG
ECHO 'VOLUM^&','   ^&'             >>LABELS.CFG
ECHO 'MAPID^&','1-yr Dose Equivalent^&' >>LABELS.CFG
%PGM%\exec\concplot +g1 -ic137.bin -z80 -x1.0E-10 -y9.6E-9 -b0 -t100 -r3 -j%PGM%\graphics\arlmap -odoseyear
doseyear.html
