@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=12
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL1
echo 1                      >>CONTROL1
echo %LAT% %LON% %LVL%      >>CONTROL1
echo %RUN%                  >>CONTROL1
echo 0                      >>CONTROL1
echo %TOP%                  >>CONTROL1
echo 1                      >>CONTROL1
echo %MET%\                 >>CONTROL1
echo %DAT%                  >>CONTROL1
echo 1                      >>CONTROL1
echo TEST                   >>CONTROL1
echo 100.0                  >>CONTROL1
echo 0.01                   >>CONTROL1
echo 00 00 00 00 00         >>CONTROL1
echo 1                      >>CONTROL1
echo 0.0 0.0                >>CONTROL1

echo x.x x.x                >>CONTROL

echo 30.0 30.0              >>CONTROL2
echo .\                     >>CONTROL2
echo cdump                  >>CONTROL2
echo 1                      >>CONTROL2
echo 5000                   >>CONTROL2
echo 00 00 00 00 00         >>CONTROL2
echo 00 00 00 00 00         >>CONTROL2
echo 01 03 00               >>CONTROL2
echo 1                      >>CONTROL2
echo 0.0 0.0 0.0            >>CONTROL2
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL2
echo 0.0 0.0 0.0            >>CONTROL2
echo 0.0                    >>CONTROL2
echo 0.0                    >>CONTROL2

REM --------------------------------------------

copy CONTROL1 CONTROL
echo 0.005 0.005            >>CONTROL
type CONTROL2               >>CONTROL

echo ^&SETUP               >SETUP.CFG
echo initd = 4,           >>SETUP.CFG
echo numpar = 1,          >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST cdump DEL cdump
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: Top-Hat ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -icdump -z25 -n1:4 -j%PGM%\graphics\arlmap
concplot.html
PAUSE

REM --------------------------------------------

echo ^&SETUP               >SETUP.CFG
echo initd = 3,           >>SETUP.CFG
echo numpar = 1,          >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST cdump DEL cdump
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: Gaussian ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -icdump -z25 -n1:4 -j%PGM%\graphics\arlmap
concplot.html
PAUSE

REM --------------------------------------

copy CONTROL1 CONTROL
echo 0.05 0.05              >>CONTROL
type CONTROL2               >>CONTROL

IF EXIST cdump DEL cdump
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: Gaussian low-res grid ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -icdump -z25 -n1:4 -j%PGM%\graphics\arlmap
concplot.html
PAUSE

REM --------------------------------------

echo ^&SETUP               >SETUP.CFG
echo initd = 3,           >>SETUP.CFG
echo numpar = 100,        >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST cdump DEL cdump
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: Gaussian low-res more puffs ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -icdump -c1 -z25 -n1:4 -j%PGM%\graphics\arlmap
concplot.html
