@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=13
SET SMO=10
SET SDA=18
SET SHR=19
    
SET LAT=43.59066 
SET LON=-112.938
SET LVL=10.0

SET RUN=3
SET TOP=10000.0

SET MET=%WRK%\sage
SET DAT=sage5_wrf01.bin
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo SF6E                   >>CONTROL
echo 3708.0                 >>CONTROL
echo 2.5                    >>CONTROL
echo 13 10 18 19 30         >>CONTROL
echo 1                      >>CONTROL
echo 43.59 -112.94          >>CONTROL
echo 1.0 0.1                >>CONTROL
echo 360.0 5.0              >>CONTROL
echo .\                     >>CONTROL
echo pdump                  >>CONTROL
echo 1                      >>CONTROL
echo 25                     >>CONTROL
echo 13 10 18 20 00         >>CONTROL
echo 13 10 18 22 00         >>CONTROL
echo 00 00 10               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo initd = 0,           >>SETUP.CFG
echo kbls = 1,            >>SETUP.CFG
echo kblt = 2,            >>SETUP.CFG
echo numpar = 50000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo cpack = 3,           >>SETUP.CFG
echo ichem = 6,           >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST pdump DEL pdump
%PGM%\exec\hycs_std

REM continue with plotting -----------------------------------

%PGM%\exec\poleplot +g1 -b%PGM%\graphics\arlmap -cpdump -l0.10 -g0 -v0

poleplot.html
