@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=13
SET SMO=10
SET SDA=18
SET SHR=19
    
SET LAT=43.59066 
SET LON=-112.938
SET LVL=10.0

SET RUN=3
SET TOP=10000.0

SET MET=%WRK%\sage
SET DAT=sage5_wrf01.bin
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo SF6E                   >>CONTROL
echo 3708.0                 >>CONTROL
echo 2.5                    >>CONTROL
echo 13 10 18 19 30         >>CONTROL
echo 1                      >>CONTROL
echo 43.59 -112.94          >>CONTROL
echo 0.001 0.001            >>CONTROL
echo 0.2 0.2                >>CONTROL
echo .\                     >>CONTROL
echo cdump                  >>CONTROL
echo 1                      >>CONTROL
echo 25                     >>CONTROL
echo 13 10 18 20 00         >>CONTROL
echo 13 10 18 22 00         >>CONTROL
echo 00 00 10               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo initd = 0,           >>SETUP.CFG
echo kbls = 1,            >>SETUP.CFG
echo kblt = 2,            >>SETUP.CFG
echo numpar = 50000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo cpack = 1,           >>SETUP.CFG
echo ichem = 6,           >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST cdump DEL cdump
%PGM%\exec\hycs_std

REM continue with statistics ---------------------------------

%PGM%\exec\c2datem -icdump -xi -osage5.txt -c1.986E+08 -m%MET%\sage5_meas.txt
%PGM%\exec\statmain -t0 -rsage5.txt -d%MET%\sage5_meas.txt -l10.0 -o1
type statA.txt
PAUSE

%PGM%\exec\scatter +g1 -idataA.txt -p10.0 
scatter.html
PAUSE

REM continue with plotting -----------------------------------

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
echo 'LAYER^&',' between ^&'  >>LABELS.CFG
echo 'UNITS^&','ppt^&'        >>LABELS.CFG
echo 'VOLUM^&','^&'           >>LABELS.CFG
echo 'RELEASE^&','SF6^&'      >>LABELS.CFG

%PGM%\exec\concplot +g1 -icdump -j%PGM%\graphics\arlmap -z100 -x1.986E+08 -g5:1 -c4 -v10000+5000+2000+1000+500+200+100+50+20+10 -q%MET%\sage5_meas.txt
concplot.html
