@echo off
setLocal EnableDelayedExpansion

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working
SET INP=hysplit2.bin

IF NOT EXIST %INP% (
   echo Missing input file %INP%
   echo Re-run previous example!
   pause
)

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -i%INP% -j%PGM%\graphics\arlmap -z80 -x1.0E+12 -upg
%PGM%\exec\splitsvg -iconcplot.html -otemp1.svg
ECHO Creating concplot animation ...
convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp1.svg concplot.gif
concplot.gif
PAUSE

ECHO Creating particle plot ...
%PGM%\exec\parxplot +g1 -iPARDUMP -j%PGM%\graphics\arlmap -k1 -z80 -n10
%PGM%\exec\splitsvg -iparxplot.html -otemp2.svg
ECHO Creating parxplot animation ...
convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp2.svg parxplot.gif
parxplot.gif
PAUSE

%PGM%\exec\isochron +g1 -i%INP% -j%PGM%\graphics\arlmap -d6 -n10 -t0.0
toa.html
PAUSE

%PGM%\exec\gridplot +g1 -i%INP% -ogridplot -j%PGM%\graphics\arlmap -c1.0E+12 -d2.0 -a1 -upg -l-1.0  
%PGM%\exec\splitsvg -igridplot.html -otemp3.svg
ECHO Creating gridplot animation ...
convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp3.svg gridplot.gif
gridplot.gif
