@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=25
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM ---------------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 67000.0                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo hysplit2.bin           >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 25 18 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 20000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST hysplit2.bin DEL hysplit2.bin
%PGM%\exec\hycs_std
RENAME MESSAGE MESSAGE_base.txt

IF EXIST plot_base.html DEL plot_base.html
ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -ihysplit2.bin -oplot_base -z80 -s1 -x1.0E+12 -upg -j%PGM%\graphics\arlmap
plot_base.html
PAUSE

REM ---------------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 2                      >>CONTROL
echo PMCH                   >>CONTROL
echo 67000.0                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL

echo POL2                   >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL

echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo hysplit2.bin           >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 25 18 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 2                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

REM -----------------------------------------------------

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo ichem = 2,           >>SETUP.CFG
echo maxdim = 2,          >>SETUP.CFG
echo numpar = 20000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM file to set conversion rate other than default
REM echo 1 2 0.10 1.0   >CHEMRATE.TXT

IF EXIST hysplit2.bin DEL hysplit2.bin
%PGM%\exec\hycs_std

IF EXIST plot_chem1.html DEL plot_chem1.html
ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -ihysplit2.bin -oplot_chem1 -z80 -s1 -x1.0E+12 -upg -j%PGM%\graphics\arlmap
plot_chem1.html
PAUSE

IF EXIST plot_chem2.html DEL plot_chem2.html
ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -ihysplit2.bin -oplot_chem2 -z80 -s2 -x1.0E+12 -upg -j%PGM%\graphics\arlmap
plot_chem2.html

