#!/bin/sh
#
# Change log:
# 19 Oct 2023 (SYZ) - remove an unnecessary line that caused error

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

  syr=83
  smo=09
  sda=28
  shr=13
     
  olat=38.665 
  olon=-71.369
  olvl=216.4
       
  run=-68
  ztop=10000.0

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL.head
  echo "1                      ">>CONTROL.head
  echo "$olat $olon $olvl      ">>CONTROL.head
  echo "$run                   ">>CONTROL.head

  echo "$ztop                  " >CONTROL.tail
  echo "1                      ">>CONTROL.tail
  echo "$MET/                  ">>CONTROL.tail
  echo "captex2_wrf27uw.bin    ">>CONTROL.tail
  echo "$OUT/                  ">>CONTROL.tail

#----------------------------------------------------------

  rm -f traj_files.txt
  rm -f tdump_data tdump_isob tdump_isen tdump_dens tdump_sigma tdump_divg
  rm -f SETUP.CFG

  cp    CONTROL.head        CONTROL
  echo "0"                >>CONTROL
  cat   CONTROL.tail      >>CONTROL
  echo "tdump_data"       >>CONTROL
  echo "tdump_data"        >traj_files.txt
  ${MDL}/exec/hyts_std    

  cp    CONTROL.head        CONTROL
  echo "1"                >>CONTROL
  cat   CONTROL.tail      >>CONTROL
  echo "tdump_isob"       >>CONTROL
  echo "tdump_isob"       >>traj_files.txt
  ${MDL}/exec/hyts_std    

  cp    CONTROL.head        CONTROL
  echo "2"                >>CONTROL
  cat   CONTROL.tail      >>CONTROL
  echo "tdump_isen"       >>CONTROL
  echo "tdump_isen"       >>traj_files.txt
  ${MDL}/exec/hyts_std    

  cp    CONTROL.head        CONTROL
  echo "3"                >>CONTROL
  cat   CONTROL.tail      >>CONTROL
  echo "tdump_dens"       >>CONTROL
  echo "tdump_dens"       >>traj_files.txt
  ${MDL}/exec/hyts_std    

  cp    CONTROL.head        CONTROL
  echo "4"                >>CONTROL
  cat   CONTROL.tail      >>CONTROL
  echo "tdump_sigma"      >>CONTROL
  echo "tdump_sigma"      >>traj_files.txt
  ${MDL}/exec/hyts_std    

  cp    CONTROL.head        CONTROL
  echo "5"                >>CONTROL
  cat   CONTROL.tail      >>CONTROL
  echo "tdump_divg"       >>CONTROL
  echo "tdump_divg"       >>traj_files.txt

  ${MDL}/exec/hyts_std    

  rm CONTROL.head CONTROL.tail

  echo "39.250 -86.663 divg"   > STATIONPLOT.CFG
  echo "39.420 -84.155 data"  >> STATIONPLOT.CFG
  echo "39.179 -75.200 isen"  >> STATIONPLOT.CFG
  echo "38.350 -74.877 dens"  >> STATIONPLOT.CFG
  echo "39.800 -72.420 sigma" >> STATIONPLOT.CFG
  echo "38.900 -72.889 isob"  >> STATIONPLOT.CFG

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -z30 -i+traj_files.txt -j${MDL}/graphics/arlmap -v0
  rm -f STATIONPLOT.CFG
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -overt004.svg
     convert F01-vert004.svg vert004.png
     rm -f F??-vert004.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi
