#!/bin/sh

WEB=""
if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
MDL=${1:-"${HOME}/hysplit"}
OUT=${2:-"${MDL}/working"}
DSP=${3:-"YES"}
TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
cd $OUT

if [ ! -f ASCDATA.CFG ]; then
   echo "-90.0  -180.0"     >ASCDATA.CFG
   echo "1.0     1.0"      >>ASCDATA.CFG
   echo "180     360"      >>ASCDATA.CFG
   echo "2"                >>ASCDATA.CFG
   echo "0.2"              >>ASCDATA.CFG
   echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
fi
echo "### ${0##*/} ###"

echo "83 09 25 17         "  >CONTROL
echo "3                   " >>CONTROL
echo "38.00 -84.00 600.0  " >>CONTROL
echo "44.00 -74.00 600.0  " >>CONTROL
echo "39.00 -83.00 600.0  " >>CONTROL
echo "6                   " >>CONTROL
echo "0                   " >>CONTROL
echo "10000.0             " >>CONTROL
echo "1                   " >>CONTROL
echo "$MET/               " >>CONTROL
echo "captex2_wrf27uw.bin " >>CONTROL
echo "./                  " >>CONTROL
echo "fdump               " >>CONTROL

rm -f SETUP.CFG
rm -f fdump
${MDL}/exec/hyts_std

echo "'TITLE&','### ${0##*/} : simple ###&'"  >LABELS.CFG
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -ifdump 
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -itrajplot.html -omult006.svg
   convert F01-mult006.svg mult006.png
   rm -f F??-mult006.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox trajplot.html &
   echo "Enter to continue ..."; read x
fi

${MDL}/exec/latlon   
${MDL}/exec/hyts_std

echo "'TITLE&','### ${0##*/} : matrix ###&'"  >LABELS.CFG
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -ifdump 
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -itrajplot.html -omult009.svg
   convert F01-mult009.svg mult009.png
   rm -f F??-mult009.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
else
   ${WEB}/firefox trajplot.html &
fi
