#!/bin/sh

WEB=""
if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
MDL=${1:-"${HOME}/hysplit"}
OUT=${2:-"${MDL}/working"}
DSP=${3:-"YES"}
HGT=${4:-"600.0"}
TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
cd $OUT

if [ ! -f ASCDATA.CFG ]; then
   echo "-90.0  -180.0"     >ASCDATA.CFG
   echo "1.0     1.0"      >>ASCDATA.CFG
   echo "180     360"      >>ASCDATA.CFG
   echo "2"                >>ASCDATA.CFG
   echo "0.2"              >>ASCDATA.CFG
   echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
fi
echo "### ${0##*/} ###"

echo "83 09 25 17         "  >CONTROL
echo "1                   " >>CONTROL
echo "39.90 -84.22 ${HGT} " >>CONTROL
echo "68                  " >>CONTROL
echo "0                   " >>CONTROL
echo "10000.0             " >>CONTROL
echo "1                   " >>CONTROL
echo "$MET/               " >>CONTROL
echo "captex2_wrf27uw.bin " >>CONTROL
echo "./                  " >>CONTROL
echo "gdump               " >>CONTROL

rm -f SETUP.CFG
rm -f gdump*       
rm -f CONTROL.???
rm -f tfreq.bin

${MDL}/exec/dat2cntl -i${MET}/captex2_meas.txt

let run=1
while [ $run -lt 1000 ];do
   RUN=`printf %3.3d $run`
   if [ -f CONTROL.$RUN ];then ${MDL}/exec/hyts_std $RUN; fi
   rm -f CONTROL.$RUN MESSAGE.$RUN
   let run=$run+1
done

ls gdump*  >INFILE
${MDL}/exec/trajfreq -ftfreq.bin -g0.5 -iINFILE -r0 -s0:99999 

echo "'TITLE&','### ${0##*/} ### Traj frequency&'"  >LABELS.CFG
echo "'MAPID&',' Values &'"             >>LABELS.CFG
echo "'UNITS&',' %&'"                   >>LABELS.CFG
echo "'VOLUM&',' &'"                    >>LABELS.CFG

${MDL}/exec/concplot +g1 -m0 -k1 -z80 -j${MDL}/graphics/arlmap -itfreq.bin
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iconcplot.html -otgeo004.svg
   convert F01-tgeo004.svg tgeo004.png
   rm -f F??-tgeo004.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html
else
   ${WEB}/firefox concplot.html &
fi

# rm -f LABELS.CFG INFILE
# rm -f tfreq.bin gdump?????_????????
# rm -f WARNING.???
