#!/bin/sh

WEB=""
if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
MDL=${1:-"${HOME}/hysplit"}
OUT=${2:-"${MDL}/working"}
DSP=${3:-"YES"}
TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
cd $OUT

if [ ! -f ASCDATA.CFG ]; then
   echo "-90.0  -180.0"     >ASCDATA.CFG
   echo "1.0     1.0"      >>ASCDATA.CFG
   echo "180     360"      >>ASCDATA.CFG
   echo "2"                >>ASCDATA.CFG
   echo "0.2"              >>ASCDATA.CFG
   echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
fi
echo "### ${0##*/} ###"

rm -f SETUP.CFG
rm -f fdump????????

YY="83"
MM="09"

for dd in  1  2  3  4  5  6  7  8  9 10 11 12 13 14 \
          15 16 17 18 19 20 21 22 23 24 25 26 27 28; do
    DD=`printf %2.2d $dd`

    for hh in 0 6 12 18;do
        HH=`printf %2.2d $hh`

        DATE="${YY}${MM}${DD}${HH}"
            
        echo "$YY $MM $DD $HH     "  >CONTROL
        echo "1                   " >>CONTROL
        echo "39.90 -84.22 600.0  " >>CONTROL
        echo "48                  " >>CONTROL
        echo "0                   " >>CONTROL
        echo "10000.0             " >>CONTROL
        echo "1                   " >>CONTROL
        echo "$MET/               " >>CONTROL
        echo "RP198309.gbl        " >>CONTROL
        echo "./                  " >>CONTROL
        echo "fdump${DATE}        " >>CONTROL

        ${MDL}/exec/hyts_std
    done
done

ls fdump???????? >INFILE
${MDL}/exec/trajfreq -ftfreq.bin -g1.0 -iINFILE -r0 -s0:99999 

echo "'TITLE&','### ${0##*/} ### Traj frequency&'"  >LABELS.CFG
echo "'MAPID&',' Values &'"             >>LABELS.CFG
echo "'UNITS&',' %&'"                   >>LABELS.CFG
echo "'VOLUM&',' &'"                    >>LABELS.CFG

${MDL}/exec/concplot +g1 -m0 -k1 -z80 -j${MDL}/graphics/arlmap -itfreq.bin
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iconcplot.html -ofreq010.svg
   convert F01-freq010.svg freq010.png
   rm -f F??-freq010.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox concplot.html &
   echo "Enter to continue ..."; read x
fi


${MDL}/exec/trajfreq -ftfreq.bin -g1.0 -iINFILE -r1 -s0:99999 
${MDL}/exec/concplot +g1 -m0 -k1 -z80 -j${MDL}/graphics/arlmap -itfreq.bin
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iconcplot.html -ofreq011.svg
   convert F01-freq011.svg freq011.png
   rm -f F??-freq011.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html
else
   ${WEB}/firefox concplot.html &
fi
