#!/bin/sh

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  echo "### ${0##*/} ###"

#------------------------------------------------------------------

#  -D[Input metdata directory name with ending /]
#  -F[input metdata file name]
#  -Y[Map center latitude]
#  -X[Map center longitude]
#  -R[Map radius (deg lat)]
#  -V[Variable name to contour (e.g. TEMP)]
#  -L[Level of variable (sfc=1)]
#  -O[Output time offset (hrs)]
#  -T[Output time interval (hrs)]
#  -C[Color (1/3) or B&W (0/2); 0/1=lines 2/3=nolines]
#  -G[Graphics map file (arlmap) or shapefiles.txt]
#  -M[Maximum contour value (Auto=-1.0)]
#  -I[Increment between contours (Auto=-1.0)]
#  -A[Arcview text output]
  
  ${MDL}/exec/contour +g1 -g${MDL}/graphics/arlmap -d$MET/ -fcaptex2_gblr.bin -y40.0 -x-80.0 -vHGTS -l4 -o48 -r25.0 -c1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -icontour.html -overt010.svg
     convert F01-vert010.svg vert010.png
     rm -f F??-vert010.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open contour.html  
  else
     ${WEB}/firefox contour.html &  
  fi
