#!/bin/sh

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  run=68
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "83 09 25 17            " >CONTROL
  echo "1                      ">>CONTROL
  echo "39.90 -84.22 600.0     ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_fwrd             ">>CONTROL

#----------------------------------------------------------

  rm -f tdump_????
  rm -f SETUP.CFG

  ${MDL}/exec/hyts_std   

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -itdump_fwrd -z80 -j${MDL}/graphics/arlmap -v0
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -oterr001.svg
     convert F01-terr001.svg terr001.png
     rm -f F??-terr001.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox trajplot.html &
     echo "Enter to continue ..."; read x
  fi

  cat tdump_fwrd | while read a b c d e f g h i j k l m; do
  echo $c $d $e $f  >CONTROL        
  echo $j $k $l     >CONTROL2
  done

#----------------------------------------------------------

  echo "1                      ">>CONTROL
  cat CONTROL2                  >>CONTROL
  echo "-$run                  ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_back             ">>CONTROL
  rm -f CONTROL2

  ${MDL}/exec/hyts_std    

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -itdump_back -z80 -j${MDL}/graphics/arlmap -v1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -oterr003.svg
     convert F01-terr003.svg terr003.png
     rm -f F??-terr003.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox trajplot.html &
     echo "Enter to continue ..."; read x
  fi

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -itdump_back+tdump_fwrd -z80 -j${MDL}/graphics/arlmap -v1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -oterr005.svg
     convert F01-terr005.svg terr005.png
     rm -f F??-terr005.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi
