#!/bin/sh

#-------------------------------------------------------------
# set default directory structure if not passed through

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------
# set model simulation variables    

  syr=83
  smo=09
  sda=25
  shr=17
     
  olat=39.90
  olon=-84.22
  olvl=10.0
        
  run=68
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------
# set up control file for dispersion/concentration simulation

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $olvl      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump                  ">>CONTROL

#----------------------------------------------------------
# run the simulation

  rm -f tdump
  rm -f SETUP.CFG

  ${MDL}/exec/hyts_std    

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -itdump -z50 -j${MDL}/graphics/arlmap -v0
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -otraj008.svg
     convert F01-traj008.svg traj008.png
     rm -f F??-traj008.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi
