#!/bin/sh

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  if [ ! -f tdump_fwrd ];then
     echo "Forward file missing ... run traj_error.sh"
     exit
  fi

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=26
  shr=03
     
  olat=41.09
  olon=-82.52
  olvl=914.0
        
  run=-10
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $olvl      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_0914             ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP               " >SETUP.CFG
  echo "kmsl=1,              ">>SETUP.CFG
  echo "/                    ">>SETUP.CFG

#----------------------------------------------------------

  rm -f tdump_0914
  ${MDL}/exec/hyts_std    

#----------------------------------------------------------

  echo "tdump_fwrd" >traj_files.txt
  echo "tdump_0914">>traj_files.txt

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -i+traj_files.txt -z80 -j${MDL}/graphics/arlmap -v1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -oabse007.svg
     convert F01-abse007.svg abse007.png
     rm -f F??-abse007.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox trajplot.html &
     echo "Enter to continue ..."; read x
  fi

#--------------------------------------------------------------

  echo "83 09 26 23            " >CONTROL
  echo "1                      ">>CONTROL
  echo "42.70 -76.17 1219.0    ">>CONTROL
  echo "-30                    ">>CONTROL
  echo "0                      ">>CONTROL
  echo "10000.0                ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_1219             ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP               " >SETUP.CFG
  echo "kmsl=1,              ">>SETUP.CFG
  echo "/                    ">>SETUP.CFG

#----------------------------------------------------------

  rm -f tdump_1219
  ${MDL}/exec/hyts_std    

#--------------------------------------------------------------

  echo "83 09 26 04            " >CONTROL
  echo "1                      ">>CONTROL
  echo "41.17 -82.79 1524.0    ">>CONTROL
  echo "-11                    ">>CONTROL
  echo "0                      ">>CONTROL
  echo "10000.0                ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_1524             ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP               " >SETUP.CFG
  echo "kmsl=1,              ">>SETUP.CFG
  echo "/                    ">>SETUP.CFG

#----------------------------------------------------------

  rm -f tdump_1524
  ${MDL}/exec/hyts_std    

#--------------------------------------------------------------

  echo "83 09 26 19            " >CONTROL
  echo "1                      ">>CONTROL
  echo "42.38 -76.14 1829.0    ">>CONTROL
  echo "-26                    ">>CONTROL
  echo "0                      ">>CONTROL
  echo "10000.0                ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_1829             ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP               " >SETUP.CFG
  echo "kmsl=1,              ">>SETUP.CFG
  echo "/                    ">>SETUP.CFG

#----------------------------------------------------------

  rm -f tdump_1829
  ${MDL}/exec/hyts_std    

#--------------------------------------------------------------

  echo "83 09 26 20            " >CONTROL
  echo "1                      ">>CONTROL
  echo "43.46 -76.15 2134.0    ">>CONTROL
  echo "-27                    ">>CONTROL
  echo "0                      ">>CONTROL
  echo "10000.0                ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_2134             ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP               " >SETUP.CFG
  echo "kmsl=1,              ">>SETUP.CFG
  echo "/                    ">>SETUP.CFG

#----------------------------------------------------------

  rm -f tdump_2134
  ${MDL}/exec/hyts_std    

#----------------------------------------------------------

  echo "tdump_fwrd" >traj_files.txt
  echo "tdump_0914">>traj_files.txt
  echo "tdump_1219">>traj_files.txt
  echo "tdump_1524">>traj_files.txt
  echo "tdump_1829">>traj_files.txt
  echo "tdump_2134">>traj_files.txt

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -i+traj_files.txt -z50 -j${MDL}/graphics/arlmap -v1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -oabse008.svg
     convert F01-abse008.svg abse008.png
     rm -f F??-abse008.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi

