#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=01 
  shr=00 
     
  olat=43.0 
  olon=-75.0  
  lvl1=10.0
        
  run=60 
  ztop=10000.0
  data="RP198309.gbl" 

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "3                      ">>CONTROL
  echo "40.0 -78.0 $lvl1       ">>CONTROL
  echo "45.0 -70.0 $lvl1       ">>CONTROL
  echo "40.5 -77.5 $lvl1       ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "1.0                    ">>CONTROL
  echo "60.0                   ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "41.0 -73.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "srm.bin                ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "83 09 03 12 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  echo "&SETUP              "  >SETUP.CFG
  echo "ichem=1,            " >>SETUP.CFG
  echo "khmax=30,           " >>SETUP.CFG
  echo "numpar=500000,      " >>SETUP.CFG
  echo "maxpar=300000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

#----------------------------------------------------------

  ${MDL}/exec/latlon  

  if [ ! -f srm.bin ]; then
     ${MDL}/exec/hycs_std
  fi
   
#----------------------------------------------------------

  rm -f sumstat.txt

  let numb=1
  let maxn=999
  cat CONTROL | while read slat slon; do

      if [ $numb -eq 1 ];then
         echo "First line"
      elif [ $numb -eq 2 ];then
         echo "Set number sources"
         let maxn=$slat+2
      elif [ $numb -gt $maxn ];then
         echo "Skip"
      else 
         ${MDL}/exec/matrix   -isrm.bin -oSRM_cdump -y$slat -x$slon -ms
         ${MDL}/exec/c2datem  -iSRM_cdump -ohysplit.txt -c1.0E+15 \
                              -m${MET}/hypo_meas.txt -xi -s
         ${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/hypo_meas.txt \
                              -o1 -ssumstat.txt
      fi
      let numb=$numb+1

  done

  ${MDL}/exec/stat2grid -isumstat.txt -ostatmap.bin -v3

  echo "'TITLE&','### ${0##*/} ### spatial statistics for CC&'"  >LABELS.CFG
  echo "'UNITS&',' &'" >>LABELS.CFG
  echo "'VOLUM&',' &'" >>LABELS.CFG

  ${MDL}/exec/gridplot +g1 -istatmap.bin -j${MDL}/graphics/arlmap -ogridplot.html \
                       -l0.0 -d0.05 -a0 -c1.0

  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -igridplot.html -otemp.svg
     convert F01-temp.svg srs003.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open gridplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox gridplot.html &   
     echo "Enter to continue ..."; read x
  fi
  cat sumstat.txt

  ${MDL}/exec/matrix   -isrm.bin -oSRM_cdump -y43.0 -x-75.0 -ms
  ${MDL}/exec/c2datem  -iSRM_cdump -ohysplit.txt -c1.0E+15 -xi \
                       -m${MET}/hypo_meas.txt 
  ${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/hypo_meas.txt -o1 
  if [[ "$DSP" == "YES" ]]; then
     echo "Enter to continue ..."; read x
  fi
  cat statA.txt

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/scatter +g1 -idataA.txt -p10.0
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iscatter.html -otemp.svg
     convert F01-temp.svg srs007.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open scatter.html
  else
     ${WEB}/firefox scatter.html &
  fi
