#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=01
  shr=00 
     
  olat=43.0  
  olon=-75.0 
  lvl1=10.0
        
  run=60 
  ztop=10000.0
  data="RP198309.gbl"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "3                      ">>CONTROL
  echo "40.0 -78.0 $lvl1       ">>CONTROL
  echo "45.0 -70.0 $lvl1       ">>CONTROL
  echo "40.5 -77.5 $lvl1       ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "1.0                    ">>CONTROL
  echo "60.0                   ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "41.0 -73.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "srm.bin                ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "83 09 03 12 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  echo "&SETUP              "  >SETUP.CFG
  echo "ichem=1,            " >>SETUP.CFG
  echo "khmax=30,           " >>SETUP.CFG
  echo "numpar=500000,      " >>SETUP.CFG
  echo "maxpar=300000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

#----------------------------------------------------------

  ${MDL}/exec/latlon  
  ${MDL}/exec/hycs_std

#----------------------------------------------------------

  ${MDL}/exec/matrix -isrm.bin -oSRM_fwrd.bin -y43.0 -x-75.0 -ms
  echo "'TITLE&','### ${0##*/} ### contributions from source&'"  >LABELS.CFG
  echo "'MAPID&','Air Concentration &'" >>LABELS.CFG
  ${MDL}/exec/concplot +g1 -k1 -z80 -j${MDL}/graphics/arlmap -iSRM_fwrd.bin
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F20-temp.svg srm008.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &   
     echo "Enter to continue ..."; read x
  fi

  ${MDL}/exec/matrix -isrm.bin -oSRM_back.bin -y44.0 -x-70.0 -mr
  echo "'TITLE&','### ${0##*/} ### sources contributing to receptor&'"  >LABELS.CFG
  echo "'MAPID&',' Values &'" >>LABELS.CFG
  ${MDL}/exec/concplot +g1 -k1 -z80 -j${MDL}/graphics/arlmap -iSRM_back.bin
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F20-temp.svg srm010.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &   
  fi
