#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  NCPU=${4:-1}  # for parallel runs
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=01
  shr=00 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=60
  ztop=10000.0
  data="RP198309.gbl"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "60.0                   ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "41.0 -73.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "cnum                   ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "83 09 03 12 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

#----------------------------------------------------------

  rm -f CONTROL.???
  ${MDL}/exec/dat2cntl -i${MET}/hypo_meas.txt -d0 -c1.0

  rm -f cnum.???
  let num=1
  NUM="001"
  while [ -f CONTROL.$NUM ];do
     cp SETUP.CFG SETUP.$NUM
     ${MDL}/exec/hycs_std $NUM &
     let num=$num+1
     NUM=`printf %3.3d $num`

     while [ 1 ]; do     
        worker_count=$(jobs -pr | wc -w)
        if [ ${worker_count} -lt ${NCPU} ]; then
           break
        fi
        sleep 15
     done
  done
  wait $(jobs -pr)
  rm MESSAGE.??? VMSDIST.??? WARNING.??? CONC.??? SETUP.0?? 

  ${MDL}/exec/conprob -bcnum -t20 -v0.0  

  echo "'TITLE&','### ${0##*/} ### Weighted Source Sensitivity&'"  >LABELS.CFG
  echo "'UNITS&',' mass &'"     >>LABELS.CFG
  echo "'VOLUM&',' &'"          >>LABELS.CFG
  echo "'MAPID&',' Receptor &'" >>LABELS.CFG
  ${MDL}/exec/concplot +g1 -m0 -k1 -z80 -j${MDL}/graphics/arlmap -icmean
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F01-temp.svg geol007.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &   
     echo "Enter to continue ..."; read x
  fi
  mv concplot.html concplot_num.html

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "60.0                   ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "41.0 -73.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "cden                   ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 01 00 00         ">>CONTROL
  echo "83 09 03 12 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f CONTROL.???
  ${MDL}/exec/dat2cntl -i${MET}/hypo_meas.txt -d1 -c1.0

  rm -f cden.???
  let num=1
  NUM="001"
  while [ -f CONTROL.$NUM ];do
     cp SETUP.CFG SETUP.$NUM
     ${MDL}/exec/hycs_std $NUM &
     let num=$num+1
     NUM=`printf %3.3d $num`

     while [ 1 ]; do     
        worker_count=$(jobs -pr | wc -w)
        if [ ${worker_count} -lt ${NCPU} ]; then
           break
        fi
        sleep 15
     done
  done
  wait $(jobs -pr)
  rm MESSAGE.??? VMSDIST.??? WARNING.??? CONC.??? SETUP.??? 

  ${MDL}/exec/conprob -bcden -t20 -v0.0  

  echo "'TITLE&','### ${0##*/} ### Inverse of the Emissions&'"  >LABELS.CFG
  echo "'UNITS&',' mass &'"     >>LABELS.CFG
  echo "'VOLUM&',' &'"          >>LABELS.CFG
  echo "'MAPID&',' Receptor &'" >>LABELS.CFG
  ${MDL}/exec/concplot +g1 -m0 -k1 -z80 -j${MDL}/graphics/arlmap -icmean
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F01-temp.svg geol008.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &  
     echo "Enter to continue ..."; read x
  fi
  mv concplot.html concplot_inv.html

#----------------------------------------------------------
# Run dispersion at 43N 75W

   syr=83
   smo=09
   sda=01
   shr=00 
 
   olat=43.00
   olon=-75.00
   lvl1=10.0
         
   run=60
   ztop=10000.0
   data="RP198309.gbl"
 
   echo "$syr $smo $sda $shr    " >CONTROL
   echo "1                      ">>CONTROL
   echo "$olat $olon $lvl1      ">>CONTROL
   echo "$run                   ">>CONTROL
   echo "0                      ">>CONTROL
   echo "$ztop                  ">>CONTROL
   echo "1                      ">>CONTROL
   echo "$MET/                  ">>CONTROL
   echo "$data                  ">>CONTROL
   echo "1                      ">>CONTROL
   echo "PMCH                   ">>CONTROL
   echo "3000.0                 ">>CONTROL
   echo "60.0                   ">>CONTROL
   echo "00 00 00 00 00         ">>CONTROL
   echo "1                      ">>CONTROL
   echo "41.0 -73.0             ">>CONTROL
   echo "0.05 0.05              ">>CONTROL
   echo "15.0 25.0              ">>CONTROL
   echo "$OUT/                  ">>CONTROL
   echo "hypo_conc.bin          ">>CONTROL
   echo "1                      ">>CONTROL
   echo "100                    ">>CONTROL
   echo "00 00 00 00 00         ">>CONTROL
   echo "00 00 00 00 00         ">>CONTROL
   echo "00 03 00               ">>CONTROL
   echo "1                      ">>CONTROL
   echo "0.0 0.0 0.0            ">>CONTROL
   echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
   echo "0.0 0.0 0.0            ">>CONTROL
   echo "0.0                    ">>CONTROL
   echo "0.0                    ">>CONTROL
 
   echo "&SETUP              "  >SETUP.CFG
   echo "initd=0,            " >>SETUP.CFG
   echo "khmax=24,           " >>SETUP.CFG
   echo "numpar=240000,      " >>SETUP.CFG
   echo "maxpar=120000,      " >>SETUP.CFG
   echo "/                   " >>SETUP.CFG
 
   rm -f hypo_conc.bin
   ${MDL}/exec/hycs_std
 
   ${MDL}/exec/conavgpd -ihypo_conc.bin -ocdump -h60

 #----------------------------------------------------------
  echo "'UNITS&','pg&'"     >LABELS.CFG
 ${MDL}/exec/concplot +g1 -icdump -j${MDL}/graphics/arlmap -z100 -x1.0E+12 -H43.0:-70.0 -c4 -v20000+10000+5000+2000+1000+500+200+100
 if [[ "$DSP" != "YES" ]]; then
    ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
    convert F01-temp.svg geol009.png
    rm -f F??-temp.svg
 elif [[ "$OSTYPE" == "darwin"* ]]; then
    open concplot.html
 else
    ${WEB}/firefox concplot.html &
 fi
