#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=10000,       " >>SETUP.CFG
  echo "maxpar=20000,       " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  syr=83
  smo=09
  olat=43.0  
  olon=-75.0  
  lvl1=10.0
  ztop=10000.0
  data="RP198309.gbl"  

#----------------------------------------------------------

  rm -f INFILE

  run=72  
  for sda in 01 02 03; do
  for shr in 00 12; do

    let run=$run-12
    rm -f tcm${smo}${sda}${shr}
  
    echo "$syr $smo $sda $shr    " >CONTROL
    echo "1                      ">>CONTROL
    echo "$olat $olon $lvl1      ">>CONTROL
    echo "$run                   ">>CONTROL
    echo "0                      ">>CONTROL
    echo "$ztop                  ">>CONTROL
    echo "1                      ">>CONTROL
    echo "$MET/                  ">>CONTROL
    echo "$data                  ">>CONTROL
    echo "1                      ">>CONTROL
    echo "PMCH                   ">>CONTROL
    echo "1.0                    ">>CONTROL
    echo "12.0                   ">>CONTROL
    echo "00 00 00 00 00         ">>CONTROL
    echo "1                      ">>CONTROL
    echo "41.0 -73.0             ">>CONTROL
    echo "0.10 0.10              ">>CONTROL
    echo "15.0 25.0              ">>CONTROL
    echo "$OUT/                  ">>CONTROL
    echo "tcm${smo}${sda}${shr}  ">>CONTROL
    echo "1                      ">>CONTROL
    echo "100                    ">>CONTROL
    echo "83 09 01 00 00         ">>CONTROL
    echo "83 09 03 12 00         ">>CONTROL
    echo "00 03 00               ">>CONTROL
    echo "1                      ">>CONTROL
    echo "0.0 0.0 0.0            ">>CONTROL
    echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
    echo "0.0 0.0 0.0            ">>CONTROL
    echo "0.0                    ">>CONTROL
    echo "0.0                    ">>CONTROL

    if [ $run -gt 0 ]; then                    
       ${MDL}/exec/hycs_std
       echo "tcm${smo}${sda}${shr}" >>INFILE
    fi
  done
  done

#------- convert HYSPLIT unit source files to TCM in CSV format ---------

  ${MDL}/exec/c2array -c1.0E+12 -iINFILE -m${MET}/hypo_meas.txt \
                      -oc2array.csv >c2array.txt
  cat c2array.csv
  if [[ "$DSP" == "YES" ]]; then
     echo "Enter to continue ..."; read x
  fi

# number of rows (measurements) and columns (sources) in matrix
  row=0
  col=0
  cat c2array.txt | while read a b c d e f; do 
  echo $e >row.txt
  echo $f >col.txt
  done
  row=`cat row.txt`
  col=`cat col.txt`
  rm -f row.txt col.txt

# ------- create namelist file of input parameters for solver -------------

guess=1000.0  # source term first guess
LNX=.false.   # convert source (X) to log 
LNY=.true.    # convert TCM (Y) to log
bound=0       # unbounded solution
Xscale=1.0    # scaling factor
uof=1.0       # observational data uncertainty: fraction
uoa=0.1       # observational data uncertainty: fixed
ubf=1.0       # source term uncertainty: fraction 
uba=0.1       # source term uncertainty: fixed

echo "&DIMENSIONS              " >PARAMETER_IN_000
echo " N_ctrl = $col,          ">>PARAMETER_IN_000
echo " Nx_ctrl = $col,         ">>PARAMETER_IN_000
echo " Ny_ctrl = 1,            ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

echo "&TCM_INPUTS              ">>PARAMETER_IN_000
echo " CSV_IN = 'c2array.csv', ">>PARAMETER_IN_000
echo " N_obs = $row,           ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

echo "&RUN_CONTRL              ">>PARAMETER_IN_000
echo " bckg_const = $guess,    ">>PARAMETER_IN_000
echo " APRIORI = 'in.dat',     ">>PARAMETER_IN_000
echo " LN_X = $LNX,            ">>PARAMETER_IN_000
echo " LN_Y = $LNY,            ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000
  
echo "&SMOOTH_PNT              ">>PARAMETER_IN_000
echo " Smoother=.true.,        ">>PARAMETER_IN_000
echo " c_smooth=1D-6,          ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

echo "&SMOOTH_P2D              ">>PARAMETER_IN_000
echo " Smooth2D=.false.,       ">>PARAMETER_IN_000
echo " x_smooth=1.0,           ">>PARAMETER_IN_000
echo " y_smooth=1.0,           ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

echo "&MODEL_UNC               ">>PARAMETER_IN_000
echo " UNC_Model=.false.,      ">>PARAMETER_IN_000
echo " T_model_unc=1.0,        ">>PARAMETER_IN_000
echo " Floor_x=1.0,            ">>PARAMETER_IN_000
echo " Ceiling_x=1.0,          ">>PARAMETER_IN_000
echo " Floor_y=1.0,            ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

echo "&LBFGS_CTRL              ">>PARAMETER_IN_000
echo " lbfgs_m = 7,            ">>PARAMETER_IN_000
echo " lbfgs_iprint=1,         ">>PARAMETER_IN_000
echo " lbfgs_factor=1.,        ">>PARAMETER_IN_000
echo " lbfgs_pgtol=1.0d-36,    ">>PARAMETER_IN_000
echo " Max_iterations=500,     ">>PARAMETER_IN_000
echo " f_factor_stop=1e-16,    ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

echo "&BOUNDS_ARR              ">>PARAMETER_IN_000
echo " lbfgs_nbd_c=$bound,     ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

echo "&UNCERTANTY              ">>PARAMETER_IN_000
echo "  X_Scaling=$Xscale,     ">>PARAMETER_IN_000
echo "  Unc_o_f=$uof,          ">>PARAMETER_IN_000
echo "  Unc_o_a=$uoa,          ">>PARAMETER_IN_000
echo "  Unc_b_f=$ubf,          ">>PARAMETER_IN_000
echo "  Unc_b_a=$uba,          ">>PARAMETER_IN_000
echo "/                        ">>PARAMETER_IN_000

# --------- cost function minimization solution -------------
  
  rm -f SOURCE_OUT_000
  ${MDL}/exec/lbfgsb 000 >LOG_cost.txt
  echo "Cost Function Solution"
  cat SOURCE_OUT_000
