#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0

  emit=3333.33
        
  run=19
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "$emit                  ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 25 18 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=10000,       " >>SETUP.CFG
  echo "maxpar=20000,       " >>SETUP.CFG
  echo "cmass=1,            " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
    
  echo "'TITLE&','### ${0##*/} ###&'"          >LABELS.CFG
  echo "'MAPID&','Particle Number&'"    >>LABELS.CFG
  echo "'LAYER&','Average&'"            >>LABELS.CFG
  echo "'UNITS&','Particle&'"           >>LABELS.CFG
  echo "'VOLUM&','&'"                   >>LABELS.CFG
  echo "'RELEASE&','&'"                 >>LABELS.CFG

  ${MDL}/exec/concplot +g1 -ihysplit2.bin -j${MDL}/graphics/arlmap \
  -z80 -c4 -v1000+500+200+100+50+20+10+5+2+1 
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F01-temp.svg cntr005.png
     convert F06-temp.svg cntr006.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &  
  fi
