#!/bin/sh
#
# Change log:
# 19 Oct 2023 (SYZ) - correct frame number when creating ephys003.png

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0  
        
  run=49
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "ensphys                ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 26 06 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  rm -f ensphys.???

  for mem in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15; do
      MEM=`printf %3.3d $mem`

                              echo "&SETUP          "  >SETUP.CFG 
                              echo "numpar=5000,    " >>SETUP.CFG 
                              echo "maxpar=10000,   " >>SETUP.CFG
                              echo "initd=0,        " >>SETUP.CFG
      if [ $mem == 1 ];  then echo "idsp=2,         " >>SETUP.CFG;fi  # STILT dispersion
      if [ $mem == 2 ];  then echo "kmixd=1,        " >>SETUP.CFG;fi  # PBL from T(z)
      if [ $mem == 3 ];  then echo "kmixd=3,        " >>SETUP.CFG;fi  # PBL from Ri(z)
      if [ $mem == 4 ];  then echo "kmix0=50,       " >>SETUP.CFG;fi  # minimum PBL
      if [ $mem == 5 ];  then echo "kzmix=1,        " >>SETUP.CFG;fi  # avrg mixing in PBL
      if [ $mem == 6 ];  then echo "kdef=1,         " >>SETUP.CFG;fi  # horiz deformation
      if [ $mem == 7 ];  then echo "kbls=2,         " >>SETUP.CFG;fi  # stb from T(z)
      if [ $mem == 8 ];  then echo "kblt=1,         " >>SETUP.CFG;fi  # Beljaars eqns
      if [ $mem == 9 ];  then echo "kblt=3,         " >>SETUP.CFG;fi  # Use TKE 
      if [ $mem == 10 ]; then echo "kblt=5,         " >>SETUP.CFG;fi  # Hanna eqns
      if [ $mem == 11 ]; then echo "vscales=200.0,  " >>SETUP.CFG;fi  # fixed stable TL
      if [ $mem == 12 ]; then echo "vscales=-1.0,   " >>SETUP.CFG;fi  # variable Hanna TL
      if [ $mem == 13 ]; then 
                              echo "kblt=1,         " >>SETUP.CFG     # Beljaars & Hanna
                              echo "vscales=-1.0,   " >>SETUP.CFG;fi 
      if [ $mem == 14 ]; then 
                              echo "kblt=3,         " >>SETUP.CFG     # TKE & Hanna
                              echo "vscales=-1.0,   " >>SETUP.CFG;fi 
      if [ $mem == 15 ]; then 
                              echo "kblt=5,         " >>SETUP.CFG     # Hanna & Hanna
                              echo "vscales=-1.0,   " >>SETUP.CFG;fi 
      echo "/" >>SETUP.CFG

      echo "Starting member: $MEM"
      ${MDL}/exec/hycs_std 
      mv ensphys ensphys.$MEM
  done

#----------------------------------------------------------

${MDL}/exec/conprob -bensphys -t1 -p1 -z1

echo "'TITLE&','### ${0##*/} ###&'"            >LABELS.CFG
echo "'UNITS&',' g&'"                   >>LABELS.CFG
echo "'MAPID&','Air Concentration&'"    >>LABELS.CFG

${MDL}/exec/concplot +g1 -m0 -k1 -z80 -j${MDL}/graphics/arlmap -iprob90
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
   convert F04-temp.svg ephys003.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox concplot.html &   
   echo "Enter to continue ..."; read x
fi
rm -f LABELS.CFG

${MDL}/exec/boxplots +g1 -n10 -x-78.80 -y42.25
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iboxplots.html -otemp.svg
   convert F01-temp.svg ephys004.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open boxplots.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox boxplots.html &   
   echo "Enter to continue ..."; read x
fi

${MDL}/exec/ensplots +g1 -n10 -bensphys -x-78.80 -y42.25
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iensplots.html -otemp.svg
   convert F01-temp.svg ephys005.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open ensplots.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox ensplots.html &   
   echo "Enter to continue ..."; read x
fi
