#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  NCPU=${4:-1}  # for parallel runs
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=200.0
        
  run=49
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "ensemble               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 26 06 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f ensemble.???

  for mem in  1  2  3  4  5  6  7  8  9 10 11 12 13 14 \
             15 16 17 18 19 20 21 22 23 24 25 26 27; do
      ${MDL}/exec/hycs_ens $mem &

      while [ 1 ]; do     
         worker_count=$(jobs -pr | wc -w)
         if [ ${worker_count} -lt ${NCPU} ]; then
            break
         fi
         sleep 15
      done
  done
  wait $(jobs -pr)

#----------------------------------------------------------

${MDL}/exec/conprob -bensemble -t1 -p1 -z1

echo "'TITLE&','### ${0##*/} ###&'"            >LABELS.CFG
echo "'UNITS&',' g&'"                   >>LABELS.CFG
echo "'MAPID&','Air Concentration&'"    >>LABELS.CFG

${MDL}/exec/concplot +g1 -m0 -k1 -z80 -j${MDL}/graphics/arlmap -iprob50
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
   convert F04-temp.svg emet008.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox concplot.html &  
   echo "Enter to continue ..."; read x
fi

${MDL}/exec/boxplots +g1 -x-78.80 -y42.25
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iboxplots.html -otemp.svg
   convert F01-temp.svg emet011.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open boxplots.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox boxplots.html &   
   echo "Enter to continue ..."; read x
fi

${MDL}/exec/ensplots +g1 -bensemble -x-78.80 -y42.25
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iensplots.html -otemp.svg
   convert F01-temp.svg emet012.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open ensplots.html    
else
   ${WEB}/firefox ensplots.html &   
fi
