#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0  
        
  run=68
  ztop=10000.0

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL1
  echo "1                      ">>CONTROL1
  echo "$olat $olon $lvl1      ">>CONTROL1
  echo "$run                   ">>CONTROL1
  echo "0                      ">>CONTROL1
  echo "$ztop                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "$MET/                  ">>CONTROL1

  echo "1                      " >CONTROL2
  echo "PMCH                   ">>CONTROL2
  echo "67000.0                ">>CONTROL2
  echo "3.0                    ">>CONTROL2
  echo "00 00 00 00 00         ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "42.0 -78.0             ">>CONTROL2
  echo "0.25 0.25              ">>CONTROL2
  echo "15.0 25.0              ">>CONTROL2
  echo "$OUT/                  ">>CONTROL2
  echo "hysplit2               ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "100                    ">>CONTROL2
  echo "83 09 25 18 00         ">>CONTROL2
  echo "83 09 28 15 00         ">>CONTROL2
  echo "00 03 00               ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  echo "0.0                    ">>CONTROL2

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=10000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.??? statA_*.txt

  let num=1

  for met in wrf27uw era40 narr wrf27 wrf09; do
      cat CONTROL1  >CONTROL
      echo captex2_${met}.bin  >>CONTROL
      cat CONTROL2 >>CONTROL

      ${MDL}/exec/hycs_std
      NUM=`printf %3.3d $num`

      ${MDL}/exec/c2datem -xi -ihysplit2 -ohysplit.txt -c1.0E+12 -m${MET}/captex2_meas.txt
      ${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/captex2_meas.txt -l10.0 -o1

      mv statA.txt statA_${met}.txt
      mv hysplit2 hysplit2.$NUM

      let num=$num+1
  done

#----------------------------------------------------------

${MDL}/exec/conprob -bhysplit2 -t1 -p1 -z1

echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
${MDL}/exec/boxplots +g1 -x-78.80 -y42.25
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iboxplots.html -otemp.svg
   convert F01-temp.svg edata006.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open boxplots.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox boxplots.html &  
   echo "Enter to continue ..."; read x
fi

${MDL}/exec/ensplots +g1 -bhysplit2 -x-78.80 -y42.25
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iensplots.html -otemp.svg
   convert F01-temp.svg edata007.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open ensplots.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox ensplots.html &  
   echo "Enter to continue ..."; read x
fi

#--------------------------------------------------------------

${MDL}/exec/c2datem -xi -icmean -ohysplit.txt -c1.0E+12 -m${MET}/captex2_meas.txt
${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/captex2_meas.txt -l10.0 -o1
${MDL}/exec/scatter +g1 -idataA.txt -p10.0
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iscatter.html -otemp.svg
   convert F01-temp.svg edata009.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open scatter.html     
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox scatter.html &   
   echo "Enter to continue ..."; read x
fi
mv statA.txt statA_cmean.txt
cat statA_cmean.txt
