#!/bin/sh
#
# Change history:
#  2 Nov 2023 (SYZ) - disable plotting with street maps as STAMEN basemaps are unavailable.
#  7 Nov 2023 (SYZ) - enable plotting with street map backgrounds.

  echo "### ${0##*/} ###"
  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  PGM="${MDL}"
  cd $OUT

  if [ ! -f cmtraj.txt ]; then
     echo "cmtraj.txt file from Sec. 7.6 is required"
     exit
  fi

  # Activate the hysplit anaconda3 environment
  ANACONDA_DIR=${HOME}/anaconda3
  source ${ANACONDA_DIR}/etc/profile.d/conda.sh
  conda activate hysplit
  PYTHON_EXE=${ANACONDA_DIR}/envs/hysplit/bin/python

  python ${PGM}/exec/trajplot.py -icmtraj.txt -j${MDL}/graphics/arlmap -l1 -ocmtraj006.png
  [ -e cmtraj0060001.png ] && mv cmtraj0060001.png cmtraj006.png

  python ${PGM}/exec/trajplot.py -icmtraj.txt -j${MDL}/graphics/arlmap -l1 --street-map=0 \
    -ocmtraj010.png
  [ -e cmtraj0100001.png ] && mv cmtraj0100001.png cmtraj010.png

  python ${PGM}/exec/trajplot.py -icmtraj.txt -j${MDL}/graphics/arlmap -l1 --street-map=1 \
    -ocmtraj009.png
  [ -e cmtraj0090001.png ] && mv cmtraj0090001.png cmtraj009.png

  #__________________________________________________________________________
  # Run the same baselined dispersion as parm_data.sh
  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=13
  ztop=10000.0
  data="captex2_wrf27uw.bin"
  run=11

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "100.0                  ">>CONTROL
  echo "0.01                   ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "2                      ">>CONTROL
  echo "800 1000               ">>CONTROL
  echo "83 09 26 03 00         ">>CONTROL
  echo "83 09 26 04 00         ">>CONTROL
  echo "00 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "kmsl=1,             " >>SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "ndump=1,            " >>SETUP.CFG
  echo "ncycl=3,            " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
    
  echo "'TITLE&','### ${0##*/} ### at flight level &'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ihysplit2.bin -j${MDL}/graphics/arlmap -z100 -x1.0E+12 -upg \
  -h41.0:-82.0 -g0:200 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q${MET}/data_case.txt 
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F01-temp.svg pyth002.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &  
     echo "Enter to continue ..."; read x
  fi

  python ${PGM}/exec/concplot.py -ihysplit2.bin -j${MDL}/graphics/arlmap -z100 -x1.0E+12 -upg \
  -h41.0:-82.0 -g0:200 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q${MET}/data_case.txt \
  --street-map=1 -opyth001.png
  [ -e pyth0010001.png ] && mv pyth0010001.png pyth001.png
