#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=12
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL 
  echo "1                      ">>CONTROL 
  echo "$olat $olon $lvl1      ">>CONTROL 
  echo "$run                   ">>CONTROL 
  echo "0                      ">>CONTROL 
  echo "$ztop                  ">>CONTROL 
  echo "1                      ">>CONTROL 
  echo "$MET/                  ">>CONTROL 
  echo "$data                  ">>CONTROL 
  echo "1                      ">>CONTROL 
  echo "TEST                   ">>CONTROL 
  echo "100.0                  ">>CONTROL 
  echo "0.01                   ">>CONTROL 
  echo "00 00 00 00 00         ">>CONTROL 
  echo "1                      ">>CONTROL 
  echo "0.0 0.0                ">>CONTROL 
  echo "0.005 0.005            ">>CONTROL
  echo "30.0 30.0              ">>CONTROL 
  echo "$OUT/                  ">>CONTROL 
  echo "cdump                  ">>CONTROL 
  echo "1                      ">>CONTROL 
  echo "5000                   ">>CONTROL 
  echo "00 00 00 00 00         ">>CONTROL 
  echo "00 00 00 00 00         ">>CONTROL 
  echo "01 03 00               ">>CONTROL 
  echo "1                      ">>CONTROL 
  echo "0.0 0.0 0.0            ">>CONTROL 
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL 
  echo "0.0 0.0 0.0            ">>CONTROL 
  echo "0.0                    ">>CONTROL 
  echo "0.0                    ">>CONTROL 

#----------------------------------------------------------

echo "&SETUP              "  >SETUP.CFG
echo "numpar=10000,       " >>SETUP.CFG
echo "ndump=3,            " >>SETUP.CFG
echo "ncycl=3,            " >>SETUP.CFG
echo "/                   " >>SETUP.CFG

rm -f cdump PARDUMP
${MDL}/exec/hycs_std    

#----------------------------------------------------------

echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
${MDL}/exec/parxplot +g1 -iPARDUMP -k1 -z80 -j${MDL}/graphics/arlmap
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iparxplot.html -ocpart005.svg
   convert F04-cpart005.svg cpart005.png
   rm -f F??-cpart005.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open parxplot.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox parxplot.html &   
   echo "Enter to continue ..."; read x
fi

${MDL}/exec/parhplot +g1 -iPARDUMP -k1 -z80 -j${MDL}/graphics/arlmap
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iparhplot.html -ocpart005b.svg
   convert F04-cpart005b.svg cpart005b.png
   rm -f F??-cpart005b.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open parhplot.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox parhplot.html &  
   echo "Enter to continue ..."; read x
fi

${MDL}/exec/parvplot +g1 -iPARDUMP -k1 -z80 -j${MDL}/graphics/arlmap
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iparvplot.html -ocpart005c.svg
   convert F04-cpart005c.svg cpart005c.png
   rm -f F??-cpart005c.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open parvplot.html    
else
   ${WEB}/firefox parvplot.html &  
fi

#----------------------------------------------------------

echo "&SETUP                "  >SETUP.CFG
echo "numpar=10000,         " >>SETUP.CFG
echo "cmtfn = 'cmtraj.txt', " >>SETUP.CFG
echo "/                     " >>SETUP.CFG

rm -f cdump
${MDL}/exec/hycs_std    

# the following command has not been tested
# it may need the command "conda activate hysplit"
# python "${MDL}/exec/trajplot.py" --interactive -icmtraj.txt -otrajplot.html -j${MDL}/graphics/arlmap -m0 -k1 -l1 -z10 -v1 -a0 -s1
${MDL}/exec/trajplot +g1 -icmtraj.txt -j${MDL}/graphics/arlmap -m0 -k1 -l1 -z10 -v1 -a0 -s1

if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -itrajplot.html -ocmtraj004.svg
   convert F01-cmtraj004.svg cmtraj004.png
   rm -f F??-cmtraj004.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html    
else
   ${WEB}/firefox trajplot.html &
fi
