#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

echo "'${TTR}/maps/roads.shp'  0 0.005 0.8 0.7 0.5"  >shapefiles.txt
echo "'${TTR}/maps/county.shp' 0 0.010 0.4 0.6 0.8" >>shapefiles.txt
echo "'${TTR}/maps/states.shp' 0 0.015 0.2 0.2 0.5" >>shapefiles.txt

#--------------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "kmsl=1,             " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  syr=83
  smo=09
  sda=25
  shr=17
  run=11
  olat=39.90
  olon=-84.22
  olvl=10.0
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $olvl      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "2                      ">>CONTROL
  echo "800 1000               ">>CONTROL
  echo "83 09 26 03 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  if [ ! -f hysplit2.bin ];then
     ${MDL}/exec/hycs_std
  else
     echo "Using previous simulation output file"
  fi

  echo "'TITLE&','### ${0##*/} ### base plume result&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -jshapefiles.txt -ihysplit2.bin \
        -a1 -z100 -x1.0E+12 -upg -h41.0:-82.0 -g0:200 -c4 -b1000 -t1000 \
        -v50000+20000+10000+5000+2000+1000
  if [[ "$DSP" != "YES" ]]; then
     echo ""
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &   
     echo "Enter to continue ..."; read x
  fi

#----------------------------------------------------------------

  if [ -f GIS_01000_html_01.txt ];then
     rm -f concplot.???
     ${MDL}/exec/ascii2shp -d concplot polygons <GIS_01000_html_01.txt
     ${MDL}/exec/txt2dbf -C11 -C5 -C9 -C5 -C6../ -C6 -d,  GIS_01000_html_01.att concplot.dbf
  fi  

#----------------------------------------------------------

  echo "83 09 25 17            " >CONTROL
  echo "1                      ">>CONTROL
  echo "39.90 -84.22 600.0     ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_fwrd             ">>CONTROL

#----------------------------------------------------------

  rm -f tdump_????
  rm -f SETUP.CFG

  ${MDL}/exec/hyts_std    

  echo "'TITLE&','### ${0##*/} ### base trajectory result&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -jshapefiles.txt -itdump_fwrd -a5 -k1 -z10 -l1 -v0
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -otemp.svg
     convert F01-temp.svg smrg002.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox trajplot.html &   
     echo "Enter to continue ..."; read x
  fi

#----------------------------------------------------------------

  if [ -f GIS_traj_html_01.txt ];then
     rm -f trajplot.???
     ${MDL}/exec/ascii2shp -d trajplot lines <GIS_traj_html_01.txt
     ${MDL}/exec/txt2dbf -C7 -C9 -C5 -C9 -d, -d, -d, GIS_traj_html_01.att trajplot.dbf
  fi  

#--------------------------------------------------------------

  echo "'${TTR}/maps/states.shp' 0 0.015 0.2 0.2 0.5" >shapefiles.txt
  echo "'concplot.shp' 0 0.010 0.4 0.6 0.8" >>shapefiles.txt
  echo "'TITLE&','### ${0##*/} ### base trajectory with plume&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -jshapefiles.txt -itdump_fwrd -k1 -z10 -l1 -v0
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itrajplot.html -otemp.svg
     convert F01-temp.svg smrg004.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox trajplot.html &   
     echo "Enter to continue ..."; read x
  fi

  echo "'${TTR}/maps/states.shp' 0 0.015 0.2 0.2 0.5" >shapefiles.txt
  echo "'trajplot.shp' 0 0.010 0.0 0.0 0.0" >>shapefiles.txt
  echo "'TITLE&','### ${0##*/} ### base plume with trajectory&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -jshapefiles.txt -ihysplit2.bin -k1 -z100 -x1.0E+12 -upg -b1000 -t1000 \
    -h41.0:-82.0 -g0:200 -c4 -v50000+20000+10000+5000+2000+1000+500 -q${MET}/data_case.txt
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F01-temp.svg smrg010.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &   
  fi
