#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "kmsl = 1,           " >>SETUP.CFG
  echo "initd = 3,          " >>SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  syr=83
  smo=09
  sda=25
  shr=17
  run=11
  olat=39.90
  olon=-84.22
  olvl=10.0
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $olvl      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "2                      ">>CONTROL
  echo "800 1000               ">>CONTROL
  echo "83 09 26 00 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "01 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  echo "1"                    >LAGSET.CFG
  echo "40.86 -81.81 914.0"  >>LAGSET.CFG
  echo "290.0 50.0"          >>LAGSET.CFG
  echo "83 09 26 02 48"      >>LAGSET.CFG
  echo "83 09 26 02 48"      >>LAGSET.CFG
  echo "06"                  >>LAGSET.CFG
  echo "06"                  >>LAGSET.CFG
  echo "'LAGOUT.TXT'"        >>LAGSET.CFG

  rm -f hysplit2.bin LAGOUT.TXT

  ${MDL}/exec/hycs_std
  cat LAGOUT.TXT

  if [[ "$DSP" != "YES" ]]; then
     echo ""
  else
     echo "Continue to delete LAGSET.CFG"
     read xxx
  fi
  rm LAGSET.CFG
