#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  MAP="${MDL}/graphics/arlmap"
  INP="hysplit2.bin"
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}

  cd $OUT

  if [ ! -f $INP ];then
     echo "Missing input file: $INP"
     echo "Run model to generate output file!"
     exit
  fi
  echo "###${0##*/} ###"

#--------------------------------------------------------------

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG

  ${MDL}/exec/concplot +g1 -i$INP -j${MDL}/graphics/arlmap -z20 -x1.0E+12 \
  -upg -b1000 -t1000 -q${MET}/captex2_avrg.txt 
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &  
  fi
