#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/volcano"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=10
  smo=04
  sda=14
  shr=00 
          
  run=12
  ztop=32000.0
  data="apr1420.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "2                      ">>CONTROL
  echo "63.63 -19.62  100.0    ">>CONTROL
  echo "63.63 -19.62 6000.0    ">>CONTROL

  echo "$run                   " >CONTROL1
  echo "0                      ">>CONTROL1
  echo "$ztop                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "$MET/                  ">>CONTROL1
  echo "$data                  ">>CONTROL1
  echo "4                      ">>CONTROL1
  echo "p006                   ">>CONTROL1
  echo "0.008E+16              ">>CONTROL1
  echo "12.0                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "p020                   ">>CONTROL1
  echo "0.068E+16              ">>CONTROL1
  echo "12.0                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "p060                   ">>CONTROL1
  echo "0.250E+16              ">>CONTROL1
  echo "12.0                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "p200                   ">>CONTROL1
  echo "0.670E+16              ">>CONTROL1
  echo "12.0                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "45.0 0.0               ">>CONTROL1
  echo "0.25 0.25              ">>CONTROL1
  echo "90.0 360.0             ">>CONTROL1
  echo "$OUT/                  ">>CONTROL1
  echo "volcano.bin            ">>CONTROL1
  echo "2                      ">>CONTROL1
  echo "0 10000                ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "00 06 00               ">>CONTROL1
  echo "4                      ">>CONTROL1
  echo "0.6 2.5 1.0            ">>CONTROL1
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL1
  echo "0.0 1.0E+06 1.0E-06    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  echo "2.0 2.5 1.0            ">>CONTROL1
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL1
  echo "0.0 1.0E+06 1.0E-06    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  echo "6.0 2.5 1.0            ">>CONTROL1
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL1
  echo "0.0 1.0E+06 1.0E-06    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  echo "20.0 2.5 1.0           ">>CONTROL1
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL1
  echo "0.0 1.0E+06 1.0E-06    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  echo "0.0                    ">>CONTROL1
  cat CONTROL1 >>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "kmsl=0,             " >>SETUP.CFG
  echo "ninit=1,            " >>SETUP.CFG
  echo "ndump=12,           " >>SETUP.CFG
  echo "ncycl=12,           " >>SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=50000,       " >>SETUP.CFG
  echo "pinpf = 'PARINIT',  " >>SETUP.CFG
  echo "poutf = 'PARDUMP',  " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f volcano.bin
  ${MDL}/exec/hycs_std  

  echo "'TITLE&','### ${0##*/} ### four size bins&'"  >LABELS.CFG

  rm -f parxplot.html
  ${MDL}/exec/parxplot +g1 -iPARDUMP -j${MDL}/graphics/arlmap -k1 -z80 
  if [[ "$DSP" != "YES" ]]; then
     echo ""
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox parxplot.html &   
     echo "Enter to continue ..."; read x
  fi

  rm -f concplot.html
  ${MDL}/exec/concplot +g1 -ivolcano.bin -j${MDL}/graphics/arlmap -b0 -t0 -s0 -z80 \
       -c4 -uug -v500000+200000+100000+50000+20000+10000+5000+2000+1000
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F02-temp.svg psize003.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &   
     echo "Enter to continue ..."; read x
  fi

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "nbptyp=5            " >>SETUP.CFG
  echo "kmsl=0,             " >>SETUP.CFG
  echo "ninit=1,            " >>SETUP.CFG
  echo "ndump=12,           " >>SETUP.CFG
  echo "ncycl=12,           " >>SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=50000,       " >>SETUP.CFG
  echo "pinpf = 'PARINIT',  " >>SETUP.CFG
  echo "poutf = 'PARDUMP',  " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f volcano.bin
  ${MDL}/exec/hycs_std  

  echo "'TITLE&','### ${0##*/} ### twenty size bins&'"  >LABELS.CFG

  rm -f parxplot.html
  ${MDL}/exec/parxplot +g1 -iPARDUMP -j${MDL}/graphics/arlmap -k1 -z80 
  if [[ "$DSP" != "YES" ]]; then
     echo ""
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox parxplot.html &  
     echo "Enter to continue ..."; read x
  fi

  rm -f concplot.html
  ${MDL}/exec/concplot +g1 -ivolcano.bin -j${MDL}/graphics/arlmap -b0 -t0 -s0 -z80 \
       -c4 -uug -v500000+200000+100000+50000+20000+10000+5000+2000+1000
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F02-temp.svg psize007.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &   
  fi
