#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/volcano"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

  if [ ! -f SETUP.CFG ];then 
     echo "SETUP.CFG from volcano simulation is required"
     exit
  fi

  if [ ! -f PARDUMP ];then 
     echo "PARDUMP file from volcano simulation is required"
     exit
  fi

  if [ ! -f CONTROL1 ];then 
     echo "CONTROL1 file from volcano simulation is required"
     exit
  fi

#--------------------------------------------------------------

  syr=10
  smo=04
  sda=14
  shr=12 

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "2                      ">>CONTROL
  echo "63.63 -19.62   100.0   ">>CONTROL
  echo "63.63 -19.62 12000.0   ">>CONTROL
  cat CONTROL1 >>CONTROL

  cp PARDUMP PARINIT
  ${MDL}/exec/hycs_std  

  echo "'TITLE&','### ${0##*/} ### eruption to 12 km&'"  >LABELS.CFG
  ${MDL}/exec/parxplot +g1 -iPARDUMP -k1 -z80 -j${MDL}/graphics/arlmap
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iparxplot.html -otemp.svg
     convert F01-temp.svg part003.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox parxplot.html &   
     echo "Enter to continue ..."; read x
  fi

#--------------------------------------------------------------

  syr=10
  smo=04
  sda=15
  shr=00 

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "2                      ">>CONTROL
  echo "63.63 -19.62   100.0   ">>CONTROL
  echo "63.63 -19.62  6000.0   ">>CONTROL
  cat CONTROL1 >>CONTROL

  cp PARDUMP PARINIT
  ${MDL}/exec/hycs_std  

  echo "'TITLE&','### ${0##*/} ### eruption to 6 km&'"  >LABELS.CFG
  ${MDL}/exec/parxplot +g1 -iPARDUMP -k1 -z80 -j${MDL}/graphics/arlmap
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iparxplot.html -otemp.svg
     convert F01-temp.svg part005.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.html    
  else
     ${WEB}/firefox parxplot.html &  
  fi
