#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  MFL=${4:-"RP201103.bin"}  # or gdas11-22.bin
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/japan"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=11
  smo=03
  sda=14
  shr=00 
          
  run=196
  ztop=10000.0
# data="RP201103.bin"
# data="gdas11-22.bin"
  data="${MFL}"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "37.4206 141.0329 100.0 ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "I131                   ">>CONTROL
  echo "5.0E+15                ">>CONTROL
  echo "24.0                   ">>CONTROL
  echo "11 03 14 12 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0                ">>CONTROL
  echo "1.0 1.0                ">>CONTROL
  echo "181.0 360.0            ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "fukushima.bin          ">>CONTROL
  echo "1                      ">>CONTROL
  echo "500                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 24 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.01 0.0 0.0 0.0 0.0   ">>CONTROL
  echo "3.00 0.0 0.0           ">>CONTROL
  echo "8.04                   ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "            >SETUP.CFG
  echo "delt=30.0           "           >>SETUP.CFG
  echo "numpar=24000,       "           >>SETUP.CFG
  echo "maxpar=25000,       "           >>SETUP.CFG
  echo "/                   "           >>SETUP.CFG

  rm -f fukushima.bin
  ${MDL}/exec/hycs_std    

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ifukushima.bin -j${MDL}/graphics/arlmap -x1000.0 -umBq
  if [[ "$DSP" != "YES" ]]; then
     echo ""
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &  
     echo "Enter to continue ..."; read x
  fi
  
  echo "DHAK 53.9 -166.5" >samplers.txt
  ${MDL}/exec/con2stn -ifukushima.bin -c1000.0 -ocon2stn.txt -r1 -ssamplers.txt >/dev/null

  cp ${MET}/LABELS.CFG .
  ${MDL}/exec/timeplot +g1 -icon2stn.txt -s${MET}/Dutch_Harbor.txt
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itimeplot.html -otemp.svg
     convert F01-temp.svg fdnpp_dhak.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open timeplot.html    
  else
     ${WEB}/firefox timeplot.html &  
  fi
