#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/dust"
  cd $OUT

  rm -f ASCDATA.CFG
  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=10
  smo=03
  sda=30
  shr=00 
          
  run=30
  ztop=10000.0
  data="WRF201003.bin"

#----------------------------------------------------------
  
  echo "&SETUP              "  >SETUP.CFG
  echo "ichem=3,            " >>SETUP.CFG
  echo "numpar=100000,      " >>SETUP.CFG
  echo "maxpar=50000,       " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "21                     ">>CONTROL

  echo "38.50 -114.00 10.0  72.0 2.000E+06" >>CONTROL
  echo "38.50 -113.75 10.0  66.3 2.000E+06" >>CONTROL
  echo "38.50 -113.25 10.0  67.4 2.000E+06" >>CONTROL
  echo "38.50 -113.00 10.0  66.6 2.000E+06" >>CONTROL
  echo "38.75 -114.00 10.0  55.1 2.000E+06" >>CONTROL
  echo "38.75 -113.75 10.0  47.3 2.000E+06" >>CONTROL
  echo "38.75 -113.50 10.0  66.4 2.000E+06" >>CONTROL
  echo "38.75 -113.00 10.0  74.8 2.000E+06" >>CONTROL
  echo "39.00 -114.00 10.0  59.9 2.000E+06" >>CONTROL
  echo "39.00 -113.75 10.0  47.3 2.000E+06" >>CONTROL
  echo "39.00 -113.50 10.0  56.8 2.000E+06" >>CONTROL
  echo "39.25 -114.00 10.0  50.9 2.000E+06" >>CONTROL
  echo "39.25 -113.75 10.0  49.9 2.000E+06" >>CONTROL
  echo "39.25 -113.50 10.0  53.9 2.000E+06" >>CONTROL
  echo "39.25 -113.25 10.0  54.6 2.000E+06" >>CONTROL
  echo "39.25 -113.00 10.0  76.6 2.000E+06" >>CONTROL
  echo "39.50 -114.00 10.0  56.7 2.000E+06" >>CONTROL
  echo "39.50 -113.75 10.0  49.3 2.000E+06" >>CONTROL
  echo "39.50 -113.50 10.0  44.8 2.000E+06" >>CONTROL
  echo "39.50 -113.25 10.0  55.2 2.000E+06" >>CONTROL
  echo "39.50 -113.00 10.0  75.1 2.000E+06" >>CONTROL

  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PM10                   ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0                ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "30.0 30.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "dust4.bin              ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "00 00 00 06 00         ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 24 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  rm -f dust4.bin
  ${MDL}/exec/hycs_std    

  echo "'TITLE&','### ${0##*/} ### adjusted emissions&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -idust4.bin -z100 -x1.0E+06 -j${MDL}/graphics/arlmap -c4 -uug \
                       -v500+200+100+50+20+10+1 -g0:400 -h40.00:-112.00 -q${MET}/AirNow_dust.txt
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F01-temp.svg dust015.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &   
     echo "Enter to continue ..."; read x
  fi

  ${MDL}/exec/c2datem -xi -idust4.bin -c1.0E+06 -m${MET}/AirNow_dust.txt -ohysplit.txt
  ${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/AirNow_dust.txt -l10.0 -o1
  ${MDL}/exec/scatter +g1 -idataA.txt -p10.0 

  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iscatter.html -otemp.svg
     convert F01-temp.svg dust014.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open scatter.html     
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox scatter.html    
     echo "Enter to continue ..."; read x
  fi

  cat statA.txt
