#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/japan"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=11
  smo=03
  sda=11
  shr=12 
          
  run=108
  ztop=10000.0
  data="gdas11-22.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "37.4206 141.0329 100.0 ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "2                      ">>CONTROL
  echo "RNUC                   ">>CONTROL
  echo "1.0                    ">>CONTROL
  echo "24.0                   ">>CONTROL
  echo "11 03 14 12 00         ">>CONTROL
  echo "NGAS                   ">>CONTROL
  echo "1.0                    ">>CONTROL
  echo "24.0                   ">>CONTROL
  echo "11 03 14 12 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0                ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "10.0 10.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "fukushima.bin          ">>CONTROL
  echo "2                      ">>CONTROL
  echo "0 500                  ">>CONTROL
  echo "11 03 14 12 00         ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 36 00               ">>CONTROL
  echo "2                      ">>CONTROL
  echo "1.0 1.0 1.0            ">>CONTROL
  echo "0.001 0.0 0.0 0.0 0.0  ">>CONTROL
  echo "0.0 8.0E-05 8.0E-05    ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "maxdim = 2,         " >>SETUP.CFG
  echo "numpar=12000,       " >>SETUP.CFG
  echo "maxpar=12000,       " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f fukushima.bin
  ${MDL}/exec/hycs_std    

  ${MDL}/exec/con2rem -afdnpp  >con2rem.log

  ${MDL}/exec/con2rem -aactivity.txt -ifukushima.bin -odose.bin -y1.0 -w0.0 \
                      -c0 -d1 -t1 -s0 -x0 -q1 >>con2rem.log

  echo "'TITLE&','### ${0##*/} ###&'"         >LABELS.CFG
  echo "'MAPID&','Accumulated Dose &'" >>LABELS.CFG
  echo "'UNITS&','mSv &'"              >>LABELS.CFG
  echo "'VOLUM&',' &'"                 >>LABELS.CFG

  ${MDL}/exec/concplot +g1 -idose.bin -j${MDL}/graphics/arlmap -odoseplot.html -k2 -z95 -s0 \
                                  -g0:250 -x1000.0 -y1000.0 -v100+50+20+5+2+1+0.5+0.2+0.1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -idoseplot.html -otemp.svg
     convert F01-temp.svg dose012.png
     convert F02-temp.svg dose013.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open doseplot.html   
  else
     ${WEB}/firefox doseplot.html &   
  fi
